/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.counterseries;

import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.counterseries.CounterSeries;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.StreamSupport;

public abstract class BasicSeries
implements CounterSeries {
    private String name;

    public BasicSeries(String name) {
        this.name = name;
    }

    @Override
    public ProblemList initialise(CaptureData captureData) {
        return new ProblemList();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public boolean isPerFrame() {
        return false;
    }

    @Override
    public boolean isAverage() {
        return false;
    }

    @Override
    public boolean isMaximum() {
        return false;
    }

    @Override
    public boolean isMinimum() {
        return false;
    }

    @Override
    public double[] toArray() {
        return this.toArray(0, this.getLength());
    }

    @Override
    public double[] toArray(int start, int end) {
        if (!this.isPresent()) {
            throw new LogicError(String.format("No data for series %s", this.getName()));
        }
        Spliterator<Double> it = Spliterators.spliteratorUnknownSize(this.iterator(start, end), 272);
        return StreamSupport.stream(it, false).mapToDouble(d -> d).toArray();
    }

    @Override
    public Iterator<Double> iterator() {
        return this.iterator(0, this.getLength());
    }

    @Override
    public String getColour() {
        return "";
    }

    @Override
    public boolean doNotShowIfAllZeroes() {
        return false;
    }

    @Override
    public boolean isAllZeroes() {
        Iterator<Double> it = this.iterator();
        while (it.hasNext()) {
            if (it.next().equals(0.0)) continue;
            return false;
        }
        return true;
    }
}

