/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.counterseries;

import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.counterseries.BasicSeries;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.DoubleStream;

public class ArraySeries
extends BasicSeries {
    private double[] data;
    private boolean isPerFrame;

    public ArraySeries(String name, double[] data, boolean isPerFrame) {
        super(name);
        if (data == null) {
            throw new LogicError("ArraySeries: array must exist");
        }
        this.data = data;
        this.isPerFrame = isPerFrame;
    }

    public ArraySeries(String name, double[] data) {
        this(name, data, false);
    }

    public ArraySeries(String name) {
        this(name, new double[0]);
    }

    public void setContent(double[] data) {
        if (data == null) {
            throw new LogicError("ArraySeries assignment: array must exist");
        }
        if (this.data.length != 0 && data.length != this.data.length) {
            throw new LogicError("ArraySeries assignment: invalid array length");
        }
        this.data = data;
    }

    @Override
    public int getLength() {
        return this.data.length;
    }

    @Override
    public boolean isPerFrame() {
        return this.isPerFrame;
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public double[] toArray() {
        return this.data;
    }

    @Override
    public double[] toArray(int start, int end) {
        if (start < 0 || start > end || end > this.getLength() || this.getLength() != 0 && start >= this.getLength()) {
            throw new LogicError("invalid array index for series " + this.getName());
        }
        return Arrays.copyOfRange(this.data, start, end);
    }

    @Override
    public Iterator<Double> iterator() {
        return DoubleStream.of(this.data).boxed().iterator();
    }

    @Override
    public Iterator<Double> iterator(int start, int end) {
        if (start < 0 || start > end || end > this.getLength() || this.getLength() != 0 && start >= this.getLength()) {
            throw new LogicError("invalid iterator index for series " + this.getName());
        }
        return DoubleStream.of(this.data).limit(end).skip(start).boxed().iterator();
    }
}

