/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.config;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.common.FatalError;
import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.config.ConfigItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import picocli.CommandLine;

public class ConfigOptions {
    List<ConfigItem<?>> configItems = new ArrayList();

    public void addConfigItems(List<ConfigItem<?>> configItemList) {
        this.configItems.addAll(configItemList);
    }

    public void addToCommandSpec(CommandLine.Model.CommandSpec cmdSpec, boolean isRelease) {
        HashMap<String, CommandLine.Model.ArgGroupSpec.Builder> groupMap = new HashMap<String, CommandLine.Model.ArgGroupSpec.Builder>();
        HashSet<String> optionNames = new HashSet<String>();
        for (ConfigItem<?> configItem : this.configItems) {
            boolean duplicate;
            if (isRelease && configItem.isDeveloperOnly()) continue;
            String name = configItem.getLongOptionName();
            boolean bl = duplicate = !optionNames.add(name);
            if (duplicate) {
                throw new LogicError(String.format("Duplicated config option name: %s", name));
            }
            Optional<String> groupOptional = configItem.getOptionalGroupName();
            if (groupOptional.isPresent()) {
                String group = groupOptional.get();
                CommandLine.Model.ArgGroupSpec.Builder builder = groupMap.getOrDefault(group, CommandLine.Model.ArgGroupSpec.builder().heading("%n" + group + ":%n%n").exclusive(false));
                builder.addArg((CommandLine.Model.ArgSpec)configItem.getOptionSpec());
                groupMap.put(group, builder);
                continue;
            }
            cmdSpec.addOption(configItem.getOptionSpec());
        }
        for (CommandLine.Model.ArgGroupSpec.Builder builder : groupMap.values()) {
            cmdSpec.addArgGroup(builder.build());
        }
    }

    public void update(CommandLine.ParseResult parseResult, boolean isDeveloperMode) {
        for (ConfigItem<?> i : this.configItems) {
            String name = i.getLongOptionName();
            if (!parseResult.hasMatchedOption(name) || !isDeveloperMode && i.isDeveloperOnly()) continue;
            i.setValue(parseResult.matchedOption(name).getValue());
            if (i.validate()) continue;
            throw new FatalError("Invalid value specified for parameter \"" + i.getName() + "\".");
        }
    }

    public void logAllConfigItems(Level logLevel) {
        if (Application.LOG.isLoggable(logLevel) && !this.configItems.isEmpty()) {
            Application.LOG.log(logLevel, String.format("Found the following %d config items:", this.configItems.size()));
            for (ConfigItem<?> i : this.configItems) {
                Application.LOG.log(logLevel, String.format("%-30s %s%s", i.getName(), i.getDescription(), i.isHidden() ? " [hidden]" : ""));
            }
        }
    }
}

