/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.common;

import com.arm.streamline.application.StreamlinePlugin;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import picocli.CommandLine;

public class VersionProvider
implements CommandLine.IVersionProvider {
    static final Pattern RELEASE_BUILD_VERSION_PATTERN = Pattern.compile("Performance Advisor \\d+.\\d+ \\(Build \\d+.\\d+.\\d+.v.*\\)", 2);
    private String fullVersion;
    private String shortVersion;
    private boolean isRelease;

    public VersionProvider() {
        String streamlineVersion = StreamlinePlugin.getVersion().getLocalizedBanner();
        this.fullVersion = streamlineVersion.replace("Streamline", "Performance Advisor");
        this.shortVersion = this.fullVersion.split("\n")[0];
        Matcher releaseVersionMatcher = RELEASE_BUILD_VERSION_PATTERN.matcher(this.shortVersion);
        this.isRelease = releaseVersionMatcher.find();
    }

    public String[] getVersion() {
        return new String[]{this.fullVersion};
    }

    public boolean isRelease() {
        return this.isRelease;
    }

    public String getShortVersion() {
        return this.shortVersion;
    }
}

