/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.common;

import com.arm.streamline.performanceadvisor.common.FatalError;

public class TargetFrameRate {
    private double target;
    private boolean displayAsFrameTime;
    private static final double MS_IN_SECONDS = 1000.0;

    public TargetFrameRate(int target, boolean displayAsFrameTime) {
        if (target <= 0) {
            throw new FatalError("The target frame rate must be greater than zero.");
        }
        this.target = target;
        this.displayAsFrameTime = displayAsFrameTime;
    }

    public double getAsMspf() {
        return 1000.0 / this.target;
    }

    public double getAsFps() {
        return this.target;
    }

    public double getTarget() {
        if (this.displayAsFrameTime) {
            return this.getAsMspf();
        }
        return this.getAsFps();
    }

    public String toString() {
        return "ms/F: " + this.getAsMspf() + " FPS: " + this.getAsFps();
    }

    public boolean getDisplayAsFrameTime() {
        return this.displayAsFrameTime;
    }
}

