/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.common;

import com.arm.streamline.performanceadvisor.common.ResourceProblem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ProblemList
implements Iterable<ResourceProblem> {
    private List<ResourceProblem> resourceProblems = new ArrayList<ResourceProblem>();

    public ProblemList() {
    }

    public ProblemList(ResourceProblem problem) {
        this.resourceProblems.add(problem);
    }

    public final boolean hasError() {
        return this.hasSeverity(ResourceProblem.Severity.ERROR);
    }

    public final boolean hasWarning() {
        return this.hasSeverity(ResourceProblem.Severity.WARNING);
    }

    public final boolean isEmpty() {
        return this.resourceProblems.isEmpty();
    }

    public void add(ResourceProblem problem) {
        this.resourceProblems.add(problem);
    }

    public void clear() {
        this.resourceProblems.clear();
    }

    public void addError(String description, String resolution) {
        this.resourceProblems.add(new ResourceProblem(ResourceProblem.Severity.ERROR, description, resolution));
    }

    public void addWarning(String description, String resolution) {
        this.resourceProblems.add(new ResourceProblem(ResourceProblem.Severity.WARNING, description, resolution));
    }

    public void addWarning(String description) {
        this.resourceProblems.add(new ResourceProblem(ResourceProblem.Severity.WARNING, description, ""));
    }

    public void addAll(ProblemList problems) {
        this.resourceProblems.addAll(problems.resourceProblems);
    }

    @Override
    public Iterator<ResourceProblem> iterator() {
        return this.resourceProblems.iterator();
    }

    public ResourceProblem get(int index) {
        return this.resourceProblems.get(index);
    }

    public int size() {
        return this.resourceProblems.size();
    }

    public ProblemList copyRemovingDuplicates() {
        ProblemList result = new ProblemList();
        List filteredList = this.resourceProblems.stream().filter(ProblemList.distinctByKey(ResourceProblem::toString)).collect(Collectors.toList());
        result.resourceProblems.addAll(filteredList);
        return result;
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> map.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    private final boolean hasSeverity(ResourceProblem.Severity severity) {
        boolean found = false;
        for (ResourceProblem p : this.resourceProblems) {
            if (p.getSeverity() != severity) continue;
            found = true;
            break;
        }
        return found;
    }

    public int hashCode() {
        return Objects.hash(this.resourceProblems);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProblemList)) {
            return false;
        }
        ProblemList other = (ProblemList)obj;
        return Objects.equals(this.resourceProblems, other.resourceProblems);
    }
}

