/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.common;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.common.LogicError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.logging.Level;

public class LogUtils {
    private LogUtils() {
        throw new IllegalStateException("LogUtils should not be instantiated");
    }

    public static void seriesStats(double[] data, String name) {
        DoubleSummaryStatistics stats = Arrays.stream(data).summaryStatistics();
        Application.LOG.fine(() -> name + ": ");
        Application.LOG.fine(() -> String.format(" avg:%.3f  min:%.3f  max:%.3f  len: %d", stats.getAverage(), stats.getMin(), stats.getMax(), stats.getCount()));
    }

    public static void seriesStats(List<double[]> data, List<String> names) {
        if (data.size() != names.size()) {
            throw new LogicError("seriesStats: array parameters should be the same size");
        }
        if (Application.LOG.isLoggable(Level.FINE)) {
            Application.LOG.fine("       Avg      Min      Max      Len      Series name");
            int i = 0;
            while (i < data.size()) {
                DoubleSummaryStatistics stats = Arrays.stream(data.get(i)).summaryStatistics();
                Application.LOG.fine(String.format("%d: %8.3f  %8.3f  %8.3f  %6d  %s", i, stats.getAverage(), stats.getMin(), stats.getMax(), stats.getCount(), names.get(i)));
                ++i;
            }
        }
    }

    public static void seriesContent(double[] data, String name) {
        Application.LOG.finest(() -> "Content of series " + name + ":");
        ArrayList<double[]> series = new ArrayList<double[]>();
        series.add(data);
        LogUtils.showSeriesContent(series, null);
    }

    public static void seriesContent(List<double[]> series) {
        LogUtils.showSeriesContent(series, null);
    }

    public static void timeSeriesContent(double[] data, String name, double msPerSample) {
        Application.LOG.finest(() -> "Content of series " + name + ":");
        ArrayList<double[]> series = new ArrayList<double[]>();
        series.add(data);
        LogUtils.showSeriesContent(series, msPerSample);
    }

    public static void timeSeriesContent(List<double[]> series, double msPerSample) {
        LogUtils.showSeriesContent(series, msPerSample);
    }

    private static void showSeriesContent(List<double[]> series, Double msPerSample) {
        if (Application.LOG.isLoggable(Level.FINEST) && !series.isEmpty()) {
            StringBuilder header = new StringBuilder();
            header.append("  Index      0");
            int i = 1;
            while (i < series.size()) {
                header.append(String.format(" %10d", i));
                ++i;
            }
            if (msPerSample != null) {
                header.append("       Time (ms)");
            }
            Application.LOG.finest(header.toString());
            int length = series.get(0).length;
            int i2 = 0;
            while (i2 < length) {
                StringBuilder log = new StringBuilder();
                log.append(String.format("%5d", i2));
                for (double[] serie : series) {
                    log.append(String.format(" %10.3f", serie[i2]));
                }
                if (msPerSample != null) {
                    log.append(String.format(" %10.2f", (double)i2 * msPerSample));
                }
                Application.LOG.finest(log.toString());
                ++i2;
            }
        }
    }

    public static int renderProgress(int count, int size) {
        double percent = (double)(++count) / (double)size * 100.0;
        double blocks = 0.25 * percent;
        int block = (int)Math.round(blocks);
        System.out.print("\r");
        System.out.print("[");
        int i = 0;
        while (i < 25) {
            if (i < block) {
                System.out.print("#");
            } else {
                System.out.print("-");
            }
            ++i;
        }
        System.out.print("]");
        return count;
    }
}

