/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata.screenshot;

import com.arm.streamline.performanceadvisor.Application;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ScreenshotUtils {
    static Optional<Integer> getFrameNumberFromFilename(Path path, int numFrames) {
        Optional<Integer> result = Optional.empty();
        String filename = path.getFileName().toString();
        if (filename.length() > 6) {
            String[] numStrArr = filename.split("_");
            String numStr = "";
            try {
                numStr = numStrArr[numStrArr.length - 1];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Application.LOG.warning(() -> "Unexpected screenshot filename format: " + String.valueOf(path));
            }
            numStr = numStr.substring(0, numStr.length() - 4);
            try {
                result = Optional.ofNullable(Integer.valueOf(numStr));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (result.isPresent()) {
            if ((Integer)result.get() >= numFrames) {
                Integer frame = result.get();
                Application.LOG.warning(() -> String.format("Frame %d out of range for screenshot: %s", frame, path));
                result = Optional.empty();
            }
        } else {
            Application.LOG.warning(() -> "Unexpected screenshot filename format: " + String.valueOf(path));
        }
        return result;
    }

    static Optional<String> findDominantContext(List<Path> screenshotPathList) {
        Optional<String> result = Optional.empty();
        if (!screenshotPathList.isEmpty() && screenshotPathList.get(0).getFileName().toString().contains("0x")) {
            HashMap<String, Integer> countMap = new HashMap<String, Integer>();
            for (Path screenshot : screenshotPathList) {
                String screenShotPathString = screenshot.getFileName().toString();
                String context = screenShotPathString.split("_")[1];
                countMap.put(context, countMap.getOrDefault(context, 0) + 1);
            }
            result = Optional.ofNullable((String)Collections.max(countMap.entrySet(), Comparator.comparingInt(Map.Entry::getValue)).getKey());
            if (result.isPresent() && countMap.size() > 1) {
                System.out.println("Multiple (" + countMap.size() + ") EGL contexts found");
                System.out.println("Automatically chosen EGL context: " + result.get());
            }
        }
        return result;
    }
}

