/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata.gpuprovider;

import com.arm.streamline.performanceadvisor.capturedata.BoundnessType;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.gpuprovider.GpuProvider;
import com.arm.streamline.performanceadvisor.capturedata.serialisation.JobManagerSerialisationCalculator;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.counterseries.BoundnessLabelledDoubleArray;
import com.arm.streamline.performanceadvisor.counterseries.CounterDescriptor;
import com.arm.streamline.performanceadvisor.counterseries.CounterIdentifier;
import com.arm.streamline.performanceadvisor.counterseries.CounterSeries;
import com.arm.streamline.performanceadvisor.counterseries.StreamlineSeries;

public class JmGpuProvider
extends GpuProvider {
    private CounterSeries fragmentUtil;
    private CounterSeries nonFragmentUtil;

    public JmGpuProvider(CaptureData captureData) {
        super(captureData);
        this.fragmentUtil = new StreamlineSeries(CounterDescriptor.fromProvider(this.counterNamesProvider, CounterIdentifier.MaliFragQueueUtil));
        this.nonFragmentUtil = new StreamlineSeries(CounterDescriptor.fromProvider(this.counterNamesProvider, CounterIdentifier.MaliNonFragQueueUtil));
        this.serialisationProvider = new JobManagerSerialisationCalculator(captureData, this.fragmentUtil, this.nonFragmentUtil);
    }

    @Override
    public ProblemList initialise() {
        ProblemList problems = super.initialise();
        problems.addAll(this.fragmentUtil.initialise(this.captureData));
        problems.addAll(this.nonFragmentUtil.initialise(this.captureData));
        return problems;
    }

    @Override
    public void execute() {
        super.execute();
        this.labelledQueueActivities.add(new BoundnessLabelledDoubleArray(BoundnessType.FRAGMENT, this.fragmentUtil.toArray()));
        this.labelledQueueActivities.add(new BoundnessLabelledDoubleArray(BoundnessType.NON_FRAGMENT, this.nonFragmentUtil.toArray()));
    }
}

