/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata.gpuprovider;

import com.arm.streamline.performanceadvisor.capturedata.BoundnessType;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.CounterNamesProvider;
import com.arm.streamline.performanceadvisor.capturedata.Provider;
import com.arm.streamline.performanceadvisor.capturedata.Region;
import com.arm.streamline.performanceadvisor.capturedata.serialisation.DisabledSerialisationCalculator;
import com.arm.streamline.performanceadvisor.capturedata.serialisation.Serialisation;
import com.arm.streamline.performanceadvisor.capturedata.serialisation.SerialisationCalculator;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.common.VectorUtils;
import com.arm.streamline.performanceadvisor.counterseries.BoundnessLabelledDoubleArray;
import com.arm.streamline.performanceadvisor.counterseries.CounterDescriptor;
import com.arm.streamline.performanceadvisor.counterseries.CounterIdentifier;
import com.arm.streamline.performanceadvisor.counterseries.CounterSeries;
import com.arm.streamline.performanceadvisor.counterseries.StreamlineSeries;
import com.arm.streamline.performanceadvisor.counterseries.UnaryOpSeries;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public abstract class GpuProvider
extends Provider {
    private CounterSeries cycles;
    private CounterSeries usage;
    private double maxCycles;
    SerialisationCalculator serialisationProvider = new DisabledSerialisationCalculator();
    @NonNull CounterNamesProvider counterNamesProvider;
    List<BoundnessLabelledDoubleArray> labelledQueueActivities;

    public GpuProvider(CaptureData captureData) {
        super(captureData);
        this.counterNamesProvider = captureData.getCounterNamesProvider();
        this.cycles = new StreamlineSeries(CounterDescriptor.fromProvider(this.counterNamesProvider, CounterIdentifier.MaliGPUActiveCy));
        this.usage = new UnaryOpSeries(this.cycles, "GPU activity", a -> a / this.maxCycles);
        this.labelledQueueActivities = new ArrayList<BoundnessLabelledDoubleArray>();
    }

    @Override
    public ProblemList initialise() {
        ProblemList problems = new ProblemList();
        problems.addAll(this.cycles.initialise(this.captureData));
        problems.addAll(this.usage.initialise(this.captureData));
        return problems;
    }

    @Override
    public void execute() {
        this.maxCycles = VectorUtils.percentile(this.cycles.toArray(), 99.0);
        if (this.maxCycles == 0.0) {
            this.maxCycles = 1.0;
        }
    }

    public CounterSeries getUtilisation() {
        return this.usage;
    }

    public List<BoundnessType> getBoundnessTypes() {
        ArrayList<BoundnessType> types = new ArrayList<BoundnessType>(Arrays.asList(BoundnessType.CPU, BoundnessType.VSYNC, BoundnessType.UNKNOWN));
        this.getLabelledQueueUtils().forEach(labelledArray -> {
            boolean bl = types.add(labelledArray.getBoundnessType());
        });
        Collections.sort(types);
        return types;
    }

    public List<BoundnessLabelledDoubleArray> getLabelledQueueUtils() {
        return this.labelledQueueActivities;
    }

    public Serialisation getSerialisation(Region region) {
        return this.serialisationProvider.getSerialisation(region);
    }
}

