/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata.gpuprovider;

import com.arm.streamline.performanceadvisor.capturedata.BoundnessType;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.gpuprovider.GpuProvider;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.counterseries.BoundnessLabelledDoubleArray;
import com.arm.streamline.performanceadvisor.counterseries.CounterDescriptor;
import com.arm.streamline.performanceadvisor.counterseries.CounterIdentifier;
import com.arm.streamline.performanceadvisor.counterseries.CounterSeries;
import com.arm.streamline.performanceadvisor.counterseries.StreamlineSeries;

public class FifthGenGpuProvider
extends GpuProvider {
    private CounterSeries computeUtil;
    private CounterSeries binningUtil;
    private CounterSeries mainUtil;

    public FifthGenGpuProvider(CaptureData captureData) {
        super(captureData);
        this.computeUtil = new StreamlineSeries(CounterDescriptor.fromProvider(this.counterNamesProvider, CounterIdentifier.MaliCompQueueUtil));
        this.binningUtil = new StreamlineSeries(CounterDescriptor.fromProvider(this.counterNamesProvider, CounterIdentifier.MaliBinningQueueUtil));
        this.mainUtil = new StreamlineSeries(CounterDescriptor.fromProvider(this.counterNamesProvider, CounterIdentifier.MaliMainQueueUtil));
    }

    @Override
    public ProblemList initialise() {
        ProblemList problems = super.initialise();
        problems.addAll(this.binningUtil.initialise(this.captureData));
        problems.addAll(this.mainUtil.initialise(this.captureData));
        problems.addAll(this.computeUtil.initialise(this.captureData));
        return problems;
    }

    @Override
    public void execute() {
        super.execute();
        this.labelledQueueActivities.add(new BoundnessLabelledDoubleArray(BoundnessType.BINNING, this.binningUtil.toArray()));
        this.labelledQueueActivities.add(new BoundnessLabelledDoubleArray(BoundnessType.MAIN, this.mainUtil.toArray()));
        this.labelledQueueActivities.add(new BoundnessLabelledDoubleArray(BoundnessType.COMPUTE, this.computeUtil.toArray()));
    }
}

