/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata;

import com.arm.io.Files;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.GpuTypeProvider;
import com.arm.streamline.performanceadvisor.capturedata.Provider;
import com.arm.streamline.performanceadvisor.common.FatalError;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class ReportConfigProvider
extends Provider {
    private static final String STANDARD_REPORT_CONFIG_DIR_PATH = "/resources/performanceadvisor/report-configs";
    private static final String DEFAULT_TEMPLATE_NAME = "report_config.json";
    private GpuTypeProvider gpuTypeProvider;
    private File capturePath;

    public ReportConfigProvider(CaptureData captureData, GpuTypeProvider gpuTypeProvider) {
        super(captureData);
        this.gpuTypeProvider = gpuTypeProvider;
        this.capturePath = captureData.getCaptureDir();
    }

    @Override
    public ProblemList initialise() {
        ProblemList problemList = new ProblemList();
        return problemList;
    }

    @Override
    public void execute() {
        assert (this.capturePath != null);
    }

    public void copyTemplateToCaptureDirectory() {
        String generatedReportTemplateFilename = "/resources/performanceadvisor/report-configs/" + this.gpuTypeProvider.getPrettyType() + ".json";
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream resource = ReportConfigProvider.class.getResourceAsStream(generatedReportTemplateFilename);){
                File newFilePath = new File(this.capturePath, DEFAULT_TEMPLATE_NAME);
                Files.copy((InputStream)resource, (File)newFilePath);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new FatalError("Failed to copy template file to capture: " + e.getMessage(), e);
        }
    }

    public boolean templateExistsWithinCaptureDirectory() {
        String templatePath = this.capturePath.getAbsolutePath() + File.separator + DEFAULT_TEMPLATE_NAME;
        File templateFile = new File(templatePath);
        return templateFile.exists();
    }
}

