/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata;

import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.ClipIndicator;
import com.arm.streamline.performanceadvisor.capturedata.InvalidClipIndicatorException;
import com.arm.streamline.performanceadvisor.capturedata.Region;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import java.util.List;

public class RegionClipIndicator
implements ClipIndicator {
    private String regionName;
    private boolean isStart;

    public RegionClipIndicator(String regionName, boolean isStart) {
        this.regionName = regionName;
        this.isStart = isStart;
    }

    @Override
    public int calculateTimestamp(CaptureData captureData, ProblemList problemList) throws InvalidClipIndicatorException {
        List<Region> regions = captureData.getUserRegionsProvider().getUserRegions();
        Region region = regions.stream().filter(r -> this.regionName.equals(r.getName())).findAny().orElse(null);
        if (region == null) {
            throw new InvalidClipIndicatorException("Region, " + this.regionName + ", not found in capture.");
        }
        return this.isStart ? region.getStart() : region.getEnd();
    }

    @Override
    public String toString() {
        String startOrEnd = this.isStart ? "start" : "end";
        return this.regionName + ":" + startOrEnd;
    }
}

