/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata;

import com.arm.streamline.model.Focus;
import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.ProcessProvider;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.common.ResourceProblem;
import com.arm.streamline.performanceadvisor.counterseries.ArraySeries;
import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.icounters.IInstructionCounterCallPaths;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.Checks;
import org.eclipse.jdt.annotation.NonNull;

public class CpuActivitySeries
extends ArraySeries {
    private String mainThread;
    private String processName;
    private int pid;
    private Optional<double[]> activity;

    public CpuActivitySeries(String mainThread) {
        super("CPU usage");
        this.mainThread = mainThread;
        this.processName = null;
        this.pid = -1;
        this.activity = Optional.empty();
    }

    public CpuActivitySeries() {
        this(null);
    }

    @Override
    public ProblemList initialise(CaptureData captureData) {
        ProblemList problemList = new ProblemList();
        ProcessProvider process = captureData.getProcessProvider();
        this.processName = process.getName();
        this.pid = process.getPid();
        if (this.mainThread != null) {
            Set<String> allThreadsInProcess = this.getAllThreadsInProcess(captureData);
            boolean mainThreadExistsInProcess = allThreadsInProcess.contains(this.mainThread);
            if (!mainThreadExistsInProcess) {
                String threadNamesString = String.join((CharSequence)System.lineSeparator(), allThreadsInProcess);
                problemList.add(new ResourceProblem(ResourceProblem.Severity.ERROR, "Thread " + this.mainThread + " not found in capture.", "Threads found: " + System.lineSeparator() + threadNamesString));
                return problemList;
            }
            Application.LOG.fine(() -> "Main thread " + this.mainThread + " found.");
        }
        this.activity = this.getActivity(captureData);
        if (this.activity.isPresent()) {
            this.setContent(this.activity.get());
        } else {
            problemList.add(new ResourceProblem(ResourceProblem.Severity.ERROR, "CPU activity information is not present in the capture.", "Please refer to the user guide for methods of getting CPU data."));
        }
        return problemList;
    }

    private Set<String> getAllThreadsInProcess(CaptureData captureData) {
        Optional<List<ICallPath>> callpathOpt = this.findCallPaths(captureData);
        HashSet<String> allThreadsInProcess = new HashSet<String>();
        if (callpathOpt.isPresent()) {
            for (ICallPath callpath : callpathOpt.get()) {
                String threadName = callpath.getExtraNameForLink();
                if (threadName == null) continue;
                allThreadsInProcess.add(threadName);
            }
        }
        return allThreadsInProcess;
    }

    @Override
    public int getLength() {
        return this.activity.isPresent() ? this.activity.get().length : 0;
    }

    @Override
    public boolean isPresent() {
        return this.activity.isPresent();
    }

    private Optional<List<ICallPath>> findCallPaths(CaptureData captureData) {
        if (this.pid < 0) {
            return Optional.empty();
        }
        @NonNull IInstructionCounterCallPaths cpf = captureData.getCallPaths();
        String procNameAndPid = String.format("%s #%d", this.processName, this.pid);
        ICallPath processCallPath = null;
        List rootCallPaths = cpf.getRootCallPaths();
        for (ICallPath cp : rootCallPaths) {
            try {
                @NonNull String callPathFullName = Objects.requireNonNull(cp.getExtraNameForLink());
                if (!callPathFullName.equals(procNameAndPid)) continue;
                processCallPath = cp;
                break;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (processCallPath == null) {
            return Optional.empty();
        }
        Application.LOG.fine("Found process call path: " + processCallPath.getFullName());
        ArrayList<@NonNull E> visitList = new ArrayList(processCallPath.getChildren());
        int ii = 0;
        while (ii < visitList.size()) {
            visitList.addAll(((ICallPath)visitList.get(ii)).getChildren());
            ++ii;
        }
        return Optional.of(visitList);
    }

    private Optional<double[]> getActivity(CaptureData captureData) {
        Optional<List<ICallPath>> callpathOpt = this.findCallPaths(captureData);
        if (!callpathOpt.isPresent()) {
            return Optional.empty();
        }
        List<ICallPath> callpaths = callpathOpt.get();
        Focus focus = captureData.getFocus();
        double[] extractedData = new double[focus.getDataBlockCount()];
        int ii = 0;
        while (ii < focus.getDataBlockCount()) {
            Map<ICallPath, TIntArrayList> data = focus.getData(ii);
            if (data != null) {
                for (Map.Entry<ICallPath, TIntArrayList> entry : data.entrySet()) {
                    ICallPath key = (ICallPath)Checks.requireNonNull((Object)entry.getKey());
                    if ((this.mainThread == null || !key.getName().equals(this.mainThread)) && this.mainThread != null || !callpaths.contains(key)) continue;
                    TIntArrayList values = (TIntArrayList)Checks.requireNonNull((Object)data.get(key));
                    extractedData[ii] = this.getPercentageFromByte(values);
                    break;
                }
            }
            ++ii;
        }
        return Optional.of(extractedData);
    }

    private double getPercentageFromByte(TIntArrayList values) {
        double val = 0.0;
        int[] nArray = values.toArray();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            int p = value & 0xFFFF;
            val += (double)p / 10000.0;
            ++n2;
        }
        return val;
    }
}

