/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata;

import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.GpuTypeProvider;
import com.arm.streamline.performanceadvisor.capturedata.Provider;
import com.arm.streamline.performanceadvisor.common.FatalError;
import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.counterseries.CounterIdentifier;
import com.arm.streamline.performanceadvisor.io.UserProvidedPath;
import com.arm.utils.NullChecking;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CounterNamesProvider
extends Provider {
    private static final String UNKNOWN_GPU_ERROR = "Error reading counter names file: could not determine GPU type. \nMake sure you are using a supported device and included the GPU counters in the capture by setting the relevant template.";
    private static final String UNKNOWN_GPU_TYPE = "UNKNOWN";
    private static final String STANDARD_COUNTER_NAMES_DIR_PATH = "/resources/performanceadvisor/counter-aliases";
    private GpuTypeProvider gpuTypeProvider;
    private Optional<@Nullable UserProvidedPath> customCounterNamesDirPath;
    private String counterNamesFilename;
    private JsonObject counterNames;

    public CounterNamesProvider(CaptureData captureData, GpuTypeProvider gpuTypeProvider, UserProvidedPath customCounterNamesDirPath) {
        super(captureData);
        this.gpuTypeProvider = gpuTypeProvider;
        this.customCounterNamesDirPath = Optional.ofNullable(customCounterNamesDirPath);
    }

    @Override
    public ProblemList initialise() {
        ProblemList problemList = new ProblemList();
        this.getCustomOrDefaultCounterAliasesDirPath();
        this.readJsonFromGenerated();
        return problemList;
    }

    private void getCustomOrDefaultCounterAliasesDirPath() {
        String gpuType;
        String counterNamesDirPath = STANDARD_COUNTER_NAMES_DIR_PATH;
        if (this.customCounterNamesDirPath.isPresent()) {
            counterNamesDirPath = this.customCounterNamesDirPath.get().getAdjustedPath().toAbsolutePath().toString();
        }
        if ((gpuType = this.gpuTypeProvider.getPrettyType()).equals(UNKNOWN_GPU_TYPE)) {
            throw new LogicError(UNKNOWN_GPU_ERROR);
        }
        this.counterNamesFilename = counterNamesDirPath + "/" + gpuType + ".json";
    }

    private InputStream openCounterStream(String fileName) throws IOException {
        if (this.customCounterNamesDirPath.isPresent()) {
            return new FileInputStream(new File(fileName));
        }
        return CounterNamesProvider.class.getResourceAsStream(fileName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JsonObject readJsonFromCounterNamesResourceFile(String fileName) {
        StringBuilder sb = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try {
                InputStream counterStream = this.openCounterStream(fileName);
                try {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(counterStream));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            sb.append(line);
                        }
                    }
                    if (counterStream == null) return JsonParser.parseString((String)sb.toString()).getAsJsonObject();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (counterStream == null) throw throwable;
                    counterStream.close();
                    throw throwable;
                }
                counterStream.close();
                return JsonParser.parseString((String)sb.toString()).getAsJsonObject();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            throw new FatalError("File \"" + fileName + "\" could not be found. Ensure counter names file is present.", e);
        }
        catch (Exception e) {
            throw new FatalError("Error reading counter names file at \"" + fileName + "\".", e);
        }
    }

    private void readJsonFromGenerated() {
        this.counterNames = this.readJsonFromCounterNamesResourceFile(this.counterNamesFilename);
    }

    @Override
    public void execute() {
        assert (this.counterNames != null);
    }

    private @NonNull String @NonNull [] getChartOrSeriesNames(@NonNull CounterIdentifier id, @NonNull String chartOrSeriesKey) {
        boolean keyFound = this.counterExists(id);
        if (!keyFound) {
            throw new FatalError("Counter name key: " + id.name() + " does not exist. Counter names files corrupt or erroneous.");
        }
        ArrayList namesFromFile = new ArrayList();
        Gson gson = new Gson();
        JsonObject chartsAndSeriesJson = this.counterNames.get(id.name()).getAsJsonObject();
        namesFromFile.addAll((Collection)gson.fromJson(chartsAndSeriesJson.get(chartOrSeriesKey), ArrayList.class));
        Object[] outputNames = namesFromFile.toArray(new String[namesFromFile.size()]);
        return (String[])NullChecking.nonNullElementsUnchecked((Object[])outputNames);
    }

    public boolean counterExists(@NonNull CounterIdentifier id) {
        return this.counterNames.get(id.name()) != null;
    }

    public @NonNull String @NonNull [] getChartNames(@NonNull CounterIdentifier id) {
        return this.getChartOrSeriesNames(id, "chartNames");
    }

    public @NonNull String @NonNull [] getSeriesNames(@NonNull CounterIdentifier id) {
        return this.getChartOrSeriesNames(id, "seriesNames");
    }
}

