/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata;

import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.model.capture.SeriesConfig;
import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.Provider;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public class CounterLogProvider
extends Provider {
    public CounterLogProvider(CaptureData captureData) {
        super(captureData);
    }

    @Override
    public ProblemList initialise() {
        List<IChartDataProvider> charts = this.captureData.getUniqueSortedChartList();
        if (Application.LOG.isLoggable(Level.FINE)) {
            int numCharts = charts.size();
            Application.LOG.fine(String.format("Capture contains %d charts:", numCharts));
            int chartCount = 1;
            for (IChartDataProvider chart : charts) {
                Application.LOG.fine(String.format("Chart %d: \"%s\"", chartCount++, chart.getTitle()));
                this.logChartInfo(chart);
            }
        }
        return new ProblemList();
    }

    private void logChartInfo(IChartDataProvider chart) {
        if (Application.LOG.isLoggable(Level.FINEST)) {
            IChartDataProvider.IChartCoreInformationProvider chartCoreInfo = chart.getCoreInformationProvider();
            Application.LOG.finest(this.indent(this.deviceInfoString(chartCoreInfo.getDeviceType()), 2));
            Application.LOG.finest(this.indent(this.channelInfoString(chartCoreInfo.getChannelDescriptors()), 2));
            int numSeries = chart.getSeries().size();
            if (numSeries > 1) {
                Application.LOG.finest(String.format("  %d series", numSeries));
            }
            for (ISeriesDataProvider series : chart.getSeries()) {
                Application.LOG.fine("  Series: " + chart.getTitle() + ":\"" + series.getName() + "\"");
                this.logSeriesInfo(series);
            }
        }
    }

    private void logSeriesInfo(ISeriesDataProvider series) {
        if (Application.LOG.isLoggable(Level.FINEST)) {
            if (series.getDescription().length() > 0) {
                Application.LOG.finest("    description: " + series.getDescription());
            }
            Application.LOG.finest(String.format("    coreLimit: %f", series.getCoreLimit()));
            Application.LOG.finest("    sources: " + String.join((CharSequence)" ", series.getSources()));
            if (series.getWarning() != null) {
                Application.LOG.finest("    warning: " + series.getWarning());
            }
            Application.LOG.finest(String.format("    isAverageSelectionPossible: %b", series.isAverageSelectionPossible()));
            Application.LOG.finest(String.format("    isFilterable: %b", series.isFilterable()));
            ISeriesDataProvider.ISeriesCoreInformationProvider coreInfo = series.getCoreInformationProvider();
            Application.LOG.finest(this.indent(this.deviceInfoString(coreInfo.getDeviceType()), 4));
            Application.LOG.finest(this.indent(this.channelInfoString(coreInfo.getChannelDescriptors()), 4));
            SeriesConfig config = series.getConfig();
            Application.LOG.finest("    expression: " + config.getExpression());
            Application.LOG.finest("    units: " + config.getUnits());
            CounterDisplay display = config.getDisplay();
            Application.LOG.finest("    display: " + display.getPresentationName());
            Set<String> sources = series.getSources();
            if (!sources.isEmpty()) {
                Application.LOG.finest(this.indent("sources:", 4));
                for (String i : sources) {
                    Application.LOG.finest(this.indent(i, 6));
                }
            }
        }
    }

    @Override
    public void execute() {
    }

    private String deviceInfoString(DeviceType type) {
        Object result = "Device type: ";
        if (type == null) {
            result = (String)result + "null";
        } else {
            result = (String)result + type.toString();
            if (type.isGPU()) {
                result = (String)result + " (";
                if (type.isMaliBifrostOrValhall()) {
                    result = (String)result + "Bifrost";
                } else if (type.isMaliMidgard()) {
                    result = (String)result + "Midgard";
                }
                result = (String)result + ")";
            }
        }
        return result;
    }

    private String channelInfoString(ProcessingElementReference[] peArray) {
        return this.channelInfoString(Set.of(peArray));
    }

    private String channelInfoString(Set<ProcessingElementReference> peSet) {
        int numChannels = peSet.size();
        StringBuilder result = new StringBuilder(this.pluralStr("channel", numChannels));
        if (numChannels > 0) {
            result.append(':');
            for (ProcessingElementReference pe : peSet) {
                result.append(' ');
                result.append(pe.toString());
            }
        }
        return result.toString();
    }

    private String pluralStr(String word, int cardinality) {
        return String.format("%d %s%s", cardinality, word, cardinality != 1 ? "s" : "");
    }

    private String indent(String str, int margin) {
        return String.join((CharSequence)"", Collections.nCopies(margin, " ")) + str;
    }
}

