/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.ClipIndicator;
import com.arm.streamline.performanceadvisor.capturedata.ClipRegion;
import com.arm.streamline.performanceadvisor.capturedata.EndClipTime;
import com.arm.streamline.performanceadvisor.capturedata.FrameProvider;
import com.arm.streamline.performanceadvisor.capturedata.InvalidClipIndicatorException;
import com.arm.streamline.performanceadvisor.capturedata.Provider;
import com.arm.streamline.performanceadvisor.capturedata.StartClipTime;
import com.arm.streamline.performanceadvisor.common.FatalError;
import com.arm.streamline.performanceadvisor.common.ProblemList;

public class ClipRegionProvider
extends Provider {
    ClipRegion clipRegion;
    ClipIndicator startClip;
    ClipIndicator endClip;

    public ClipRegionProvider(CaptureData captureData, ClipIndicator startClip, ClipIndicator endClip) {
        super(captureData);
        this.startClip = startClip;
        this.endClip = endClip;
    }

    @Override
    public ProblemList initialise() {
        ProblemList problemList = new ProblemList();
        FrameProvider frameProvider = this.captureData.getFrameProvider();
        if (frameProvider.hasError()) {
            return problemList;
        }
        int firstFrameStart = frameProvider.getFirstFrame().getStart();
        int lastFrameEnd = frameProvider.getLastFrame().getEnd();
        StartClipTime startClipTime = this.initialiseClipStartTime(problemList, firstFrameStart, lastFrameEnd);
        Application.LOG.fine("Setting start of clip region to " + startClipTime.getTimestamp());
        EndClipTime endClipTime = this.initialiseClipEndTime(problemList, firstFrameStart, lastFrameEnd);
        Application.LOG.fine("Setting end of clip region to " + endClipTime.getTimestamp());
        if (endClipTime.getTimestamp() < startClipTime.getTimestamp()) {
            String startClipTimeStr = startClipTime.toString();
            String startClipTimeStrCapitalised = startClipTimeStr.substring(0, 1).toUpperCase() + startClipTimeStr.substring(1);
            throw new FatalError(startClipTimeStrCapitalised + " must be before the " + endClipTime.toString() + ".");
        }
        this.clipRegion = new ClipRegion(startClipTime, endClipTime);
        return problemList;
    }

    private EndClipTime initialiseClipEndTime(ProblemList problemList, int firstFrameStart, int lastFrameEnd) {
        if (this.endClip != null) {
            int endClipTime;
            try {
                endClipTime = this.endClip.calculateTimestamp(this.captureData, problemList);
            }
            catch (InvalidClipIndicatorException e) {
                throw new FatalError("Error with end clip, " + this.endClip.toString() + ". " + e.getMessage());
            }
            if (endClipTime > lastFrameEnd) {
                problemList.addWarning("End clip, " + this.endClip.toString() + ", occurs after the end of the last frame, " + lastFrameEnd, "Setting end clip time to the end of the last frame.");
                endClipTime = lastFrameEnd;
            }
            if (endClipTime < firstFrameStart) {
                throw new FatalError("End clip, " + this.startClip.toString() + ", occurs before the start of the first frame.");
            }
            return new EndClipTime(endClipTime, true);
        }
        return new EndClipTime(lastFrameEnd, false);
    }

    private StartClipTime initialiseClipStartTime(ProblemList problemList, int firstFrameStart, int lastFrameEnd) {
        if (this.startClip != null) {
            int startClipTimestamp;
            try {
                startClipTimestamp = this.startClip.calculateTimestamp(this.captureData, problemList);
            }
            catch (InvalidClipIndicatorException e) {
                throw new FatalError("Error with start clip, " + this.startClip.toString() + ". " + e.getMessage());
            }
            if (startClipTimestamp < firstFrameStart) {
                problemList.addWarning("Start clip, " + this.startClip.toString() + ", occurs before the start of the first frame, " + firstFrameStart, "Setting start clip time to the start of the first frame.");
                startClipTimestamp = this.captureData.getFrameProvider().getFirstFrame().getStart();
            }
            if (startClipTimestamp > lastFrameEnd) {
                throw new FatalError("Start clip time, " + this.startClip.toString() + ", occurs after the end of the final frame.");
            }
            return new StartClipTime(startClipTimestamp, true);
        }
        return new StartClipTime(firstFrameStart, false);
    }

    @Override
    public void execute() {
    }

    public ClipRegion getClipRegion() {
        return this.clipRegion;
    }
}

