/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.analyser;

import com.arm.streamline.performanceadvisor.analyser.Analyser;
import com.arm.streamline.performanceadvisor.analyser.AnalyserFactory;
import com.arm.streamline.performanceadvisor.capturedata.BinFrameProvider;
import com.arm.streamline.performanceadvisor.capturedata.BoundnessProvider;
import com.arm.streamline.performanceadvisor.capturedata.BoundnessType;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.ClippedRegionsProvider;
import com.arm.streamline.performanceadvisor.capturedata.CpuProvider;
import com.arm.streamline.performanceadvisor.capturedata.FpsProvider;
import com.arm.streamline.performanceadvisor.capturedata.Region;
import com.arm.streamline.performanceadvisor.capturedata.gpuprovider.GpuProvider;
import com.arm.streamline.performanceadvisor.capturedata.serialisation.Serialisation;
import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.common.TimeUtils;
import com.arm.streamline.performanceadvisor.common.VectorUtils;
import com.arm.streamline.performanceadvisor.section.BarChart;
import com.arm.streamline.performanceadvisor.section.Element;
import com.arm.streamline.performanceadvisor.section.ElementGroup;
import com.arm.streamline.performanceadvisor.section.GaugeChart;
import com.arm.streamline.performanceadvisor.section.KeyValue;
import com.arm.streamline.performanceadvisor.section.Section;
import com.arm.streamline.performanceadvisor.section.TextBlock;
import com.arm.streamline.performanceadvisor.section.TextStyle;
import com.arm.streamline.performanceadvisor.section.Unit;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SummaryAnalyserFactory
extends AnalyserFactory {
    @Override
    public SummaryAnalyser create(CaptureData captureData) {
        return new SummaryAnalyser(captureData);
    }

    public class SummaryAnalyser
    extends Analyser {
        private final String cpuUrlParameter;
        private final String fragmentUrlParameter;
        private final String nonFragmentUrlParamter;
        private final String cpuGpuSchedulingParameter;
        private final String qpuQueueSchedulingParameter;
        private ClippedRegionsProvider clippedRegionsProvider;
        private BoundnessProvider boundnessProvider;
        private BinFrameProvider binFrameProvider;
        private FpsProvider fpsProvider;
        private CpuProvider cpuProvider;
        private GpuProvider gpuProvider;
        private static final int FPS_SERIES_DECIMAL_PLACES = 2;

        public SummaryAnalyser(CaptureData captureData) {
            super(captureData);
            this.cpuUrlParameter = String.format("https://developer.arm.com/documentation/102643/latest/%s", "Improving-CPU-bound-content");
            this.fragmentUrlParameter = String.format("https://developer.arm.com/documentation/102643/latest/%s", "Improving-fragment-bound-content");
            this.nonFragmentUrlParamter = String.format("https://developer.arm.com/documentation/102643/latest/%s", "Improving-non-fragment-bound-content");
            this.cpuGpuSchedulingParameter = String.format("https://developer.arm.com/documentation/102643/latest/%s", "Improving-CPU-to-GPU-scheduling-bound-content");
            this.qpuQueueSchedulingParameter = String.format("https://developer.arm.com/documentation/102643/latest/%s", "Improving-GPU-queue-scheduling-bound-content");
        }

        @Override
        public ProblemList initialise() {
            this.clippedRegionsProvider = this.captureData.getClippedRegionsProvider();
            this.boundnessProvider = this.captureData.getBoundnessProvider();
            this.binFrameProvider = this.captureData.getBinFrameProvider();
            this.cpuProvider = this.captureData.getCpuProvider();
            this.gpuProvider = this.captureData.getGpuProvider();
            this.fpsProvider = this.captureData.getFpsProvider();
            return new ProblemList();
        }

        @Override
        public Section execute(int userRegion) {
            ArrayList<Element> elements = new ArrayList<Element>();
            Region region = this.clippedRegionsProvider.getClippedRegion(userRegion);
            this.addHeading(userRegion, region, elements);
            this.addRegionTimingsToJson(region, elements);
            Serialisation containsSerialisation = this.gpuProvider.getSerialisation(region);
            LinkedHashMap<BoundnessType, Double> boundnessPercentages = this.boundnessProvider.getBoundnessPercentageSplitForRegion(region);
            this.addAdvice(containsSerialisation, boundnessPercentages, elements, userRegion);
            List<Element> groupedElements = this.createGroupedElements(boundnessPercentages, region);
            elements.add(new ElementGroup("Performance", groupedElements));
            if (userRegion == 0) {
                return new Section("allCapture", elements);
            }
            return new Section("summary", elements, region.getName());
        }

        private void addHeading(int regionNum, Region region, List<Element> elements) {
            if (regionNum != 0) {
                String heading = String.format("%s (%s - %s, Frame %s - %s)", region.getName(), TimeUtils.msToMmSsFormat(region.getStart()), TimeUtils.msToMmSsFormat(region.getEnd()), this.binFrameProvider.getLowestFrameNumberForTime(region.getStart()), this.binFrameProvider.getHighestFrameNumberForTime(region.getEnd()));
                elements.add(new TextBlock(TextStyle.H1, heading, new TextBlock.TextBlockId(region.getId())));
            } else {
                elements.add(new TextBlock(TextStyle.H1, "Capture summary", "<p>These charts show the metrics for the whole duration of the capture. In the " + this.fpsProvider.getPerFrame().getNameToDisplayLong() + " analysis chart, you can see these metrics for a selected section of the capture.<br><br>Average " + this.fpsProvider.getPerFrame().getNameToDisplayLong() + ":<br>Loading screens may affect the average " + this.fpsProvider.getPerFrame().getNameToDisplayLong() + ", and prevent this metric from indicating the true performance. Use this metric for guidance, and to compare performance between runs.<br><br>Boundness distribution:<br>See which bottlenecks are affecting your performance. A high VSYNC value shows that your application is achieving the target " + this.fpsProvider.getPerFrame().getNameToDisplayLong() + ".<br><br>Resource utilization:<br>See where your application is spending most of its time.</p>"));
            }
        }

        private void addRegionTimingsToJson(Region region, List<Element> elements) {
            KeyValue startFrameKey = new KeyValue("startFrame", String.valueOf(this.binFrameProvider.getHighestFrameNumberForTime(region.getStart())));
            startFrameKey.setExcludeFromHtml(true);
            elements.add(startFrameKey);
            KeyValue endFrameKey = new KeyValue("endFrame", String.valueOf(this.binFrameProvider.getHighestFrameNumberForTime(region.getEnd())));
            endFrameKey.setExcludeFromHtml(true);
            elements.add(endFrameKey);
            KeyValue startTimeKey = new KeyValue("startTime", String.valueOf(region.getStart()));
            startTimeKey.setExcludeFromHtml(true);
            elements.add(startTimeKey);
            KeyValue endTimeKey = new KeyValue("endTime", String.valueOf(region.getEnd()));
            endTimeKey.setExcludeFromHtml(true);
            elements.add(endTimeKey);
            KeyValue durationKey = new KeyValue("duration", String.valueOf(region.getEnd() - region.getStart()));
            durationKey.setExcludeFromHtml(true);
            elements.add(durationKey);
        }

        private BoundnessType getMajorityBoundness(LinkedHashMap<BoundnessType, Double> boundnessPercentages) {
            return (BoundnessType)((Object)Collections.max(boundnessPercentages.entrySet(), Map.Entry.comparingByValue()).getKey());
        }

        public List<Element> createGroupedElements(LinkedHashMap<BoundnessType, Double> boundnessPercentages, Region region) {
            ArrayList<Element> groupedElements = new ArrayList<Element>();
            double avgFrameSeries = VectorUtils.avg(Arrays.copyOfRange(this.fpsProvider.getPerBin().getSeriesToDisplay().toArray(), region.getStart(), region.getEnd()));
            avgFrameSeries = BigDecimal.valueOf(avgFrameSeries).setScale(2, RoundingMode.HALF_UP).doubleValue();
            String frameSeriesChartTitle = "Average " + this.fpsProvider.getPerFrame().getNameToDisplayLong();
            Unit frameSeriesChartUnit = this.fpsProvider.getPerFrame().getUnitToDisplay();
            if (this.captureData.getTargetFrameRate().getDisplayAsFrameTime()) {
                groupedElements.add(new BarChart(new String[]{"Frame Time (ms)"}, new double[]{avgFrameSeries}, avgFrameSeries * 1.25, frameSeriesChartUnit, frameSeriesChartTitle, frameSeriesChartTitle, region.getName()));
            } else {
                groupedElements.add(new GaugeChart(frameSeriesChartTitle, avgFrameSeries, this.captureData.getTargetFrameRate().getAsFps(), frameSeriesChartUnit, region.getName()));
            }
            groupedElements.add(BarChart.create(boundnessPercentages, 100.0, Unit.PERCENTAGE, "Boundness Split", "Boundness distribution", region.getName()));
            groupedElements.add(new BarChart(new String[]{"Average CPU utilization", "Average GPU utilization"}, new double[]{100.0 * VectorUtils.avg(this.cpuProvider.getUsage().toArray(region.getStart(), region.getEnd())), 100.0 * VectorUtils.avg(this.gpuProvider.getUtilisation().toArray(region.getStart(), region.getEnd()))}, 100.0, Unit.PERCENTAGE, "Average Utilization", "Resource utilization", region.getName()));
            return groupedElements;
        }

        private void addAdvice(Serialisation containsSerialisation, LinkedHashMap<BoundnessType, Double> boundnessPercentages, List<Element> elements, int userRegion) {
            BoundnessType majorityBoundness = this.getMajorityBoundness(boundnessPercentages);
            Double vsyncPercentage = boundnessPercentages.getOrDefault((Object)BoundnessType.VSYNC, 0.0);
            String scope = userRegion == 0 ? "your application" : "this region";
            String advice = String.format("You are hitting your performance target for %.0f%% of the time within %s.", vsyncPercentage, scope);
            String boundText = " For the frames below target you are predominantly ";
            try {
                switch (majorityBoundness) {
                    case CPU: {
                        elements.add(new TextBlock(TextStyle.ADVICE, advice + boundText + "CPU bound.", URI.create(this.cpuUrlParameter).toURL()));
                        break;
                    }
                    case NON_FRAGMENT: {
                        elements.add(new TextBlock(TextStyle.ADVICE, advice + boundText + "non-fragment bound.", URI.create(this.nonFragmentUrlParamter).toURL()));
                        break;
                    }
                    case FRAGMENT: {
                        elements.add(new TextBlock(TextStyle.ADVICE, advice + boundText + "fragment bound.", URI.create(this.fragmentUrlParameter).toURL()));
                        break;
                    }
                    default: {
                        elements.add(new TextBlock(TextStyle.ADVICE, advice));
                    }
                }
                String scopeWithFirstCharCapitalised = scope.substring(0, 1).toUpperCase() + scope.substring(1);
                if (containsSerialisation.getCpuGpuSerialisation()) {
                    elements.add(new TextBlock(TextStyle.WARNING, scopeWithFirstCharCapitalised + " may contain CPU-GPU scheduling issues.", URI.create(this.cpuGpuSchedulingParameter).toURL()));
                }
                if (containsSerialisation.getVertFragSerialisation()) {
                    elements.add(new TextBlock(TextStyle.WARNING, scopeWithFirstCharCapitalised + " may contain GPU queue scheduling issues.", URI.create(this.qpuQueueSchedulingParameter).toURL()));
                }
            }
            catch (MalformedURLException e) {
                throw new LogicError("Malformed URL");
            }
        }
    }
}

