/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.analyser;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.analyser.BinnedData;
import com.arm.streamline.performanceadvisor.common.LogUtils;
import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.counterseries.CounterSeries;
import com.arm.streamline.performanceadvisor.counterseries.FrameMetricSeries;
import com.arm.streamline.performanceadvisor.section.DualAxisLineChart;
import com.arm.streamline.performanceadvisor.section.Element;
import java.util.ArrayList;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Optional;

public class PerFrameChartData {
    private double[] fpsData;
    private String unitsName;
    private BinnedData binnedData;
    private boolean enableFpsScaling;
    private String group;
    private FrameMetricSeries frameMetricSeries;
    private Optional<Double> threshold;
    private String budgetLabel;
    private List<String> ycolours;
    private boolean needsStreamlineColours;

    public PerFrameChartData(int binSize, int samplesPerSecond, FrameMetricSeries frameMetricSeries, int offset, int endIndex, boolean enableFpsScaling, String group) {
        this.frameMetricSeries = frameMetricSeries;
        this.enableFpsScaling = enableFpsScaling;
        this.group = group;
        this.fpsData = frameMetricSeries.getFps().toArray(offset, endIndex);
        this.threshold = Optional.empty();
        this.binnedData = new BinnedData(binSize, samplesPerSecond, offset);
        this.binnedData.addSeries(frameMetricSeries.getSeriesToDisplay().toArray(offset, endIndex), frameMetricSeries.getNameToDisplayShort(), false);
        this.ycolours = new ArrayList<String>();
        this.needsStreamlineColours = false;
    }

    public PerFrameChartData addSeries(double[] data, String name, boolean backfill) {
        return this.addSeries(data, name, backfill, "", false, false);
    }

    private PerFrameChartData addSeries(double[] data, String name, boolean backfill, String colour, boolean isMaximum, boolean isMinimum) {
        Application.LOG.fine(() -> String.format("Add series %s of length %d to per-frame chart", name, data.length));
        if (isMaximum || isMinimum) {
            this.binnedData.addSeries(data, name, backfill, isMaximum);
        } else {
            this.binnedData.addSeries(this.scaleSeriesByFps(data, this.fpsData), name, backfill, isMaximum);
        }
        this.ycolours.add(colour);
        if (this.enableFpsScaling && !isMaximum && !isMinimum) {
            Application.LOG.fine(() -> String.format("Scaling data series %s for sample rate", name));
            this.binnedData.scaleSeriesForSampleRate(this.binnedData.getNumSeries() - 1);
        }
        return this;
    }

    public PerFrameChartData addSeries(CounterSeries counterSeries, int startIndex, int endIndex) {
        if (!counterSeries.isPresent()) {
            throw new LogicError("PerFrameChartData: series data not present");
        }
        double[] data = counterSeries.toArray(startIndex, endIndex);
        String colour = counterSeries.getColour();
        String name = counterSeries.getName();
        boolean backfill = !counterSeries.isAverage();
        boolean isMax = counterSeries.isMaximum();
        boolean isMin = counterSeries.isMinimum();
        return this.addSeries(data, name, backfill, colour, isMax, isMin);
    }

    public PerFrameChartData setUnitsName(String unitsName) {
        this.unitsName = unitsName;
        return this;
    }

    public PerFrameChartData setThreshold(Optional<Double> threshold, String budgetLabel) {
        this.threshold = threshold;
        this.budgetLabel = budgetLabel;
        return this;
    }

    public double[] getSeries(int index) {
        return this.binnedData.getSeries(index + 1);
    }

    public String getName(int index) {
        return this.binnedData.getName(index + 1);
    }

    public boolean needsStreamlineColours() {
        return this.needsStreamlineColours;
    }

    public void setToNeedStreamlineColours() {
        this.needsStreamlineColours = true;
    }

    public Element getChart() {
        double xdataStart = this.binnedData.getTimes()[0];
        int xdataLength = this.binnedData.getTimes().length;
        double xdataStep = this.binnedData.getBinDurationMs();
        DualAxisLineChart chart = new DualAxisLineChart("Time (s)", xdataStart, xdataLength, xdataStep, this.binnedData.getName(0), this.binnedData.getSeries(0), this.group);
        int i = 0;
        while (i < this.binnedData.getNumSeries() - 1) {
            chart.addSeries(this.getName(i), this.getSeries(i), this.ycolours.get(i));
            ++i;
        }
        double rhsAxisLimit = this.findRhsAxisLimit();
        double ylimit = this.findYAxisLimit();
        int rhsAxisTickCount = (int)Math.min(rhsAxisLimit / 10.0 + 1.0, 12.0);
        Application.LOG.fine(() -> String.format("Max Y axis value will be %.2f", ylimit));
        Application.LOG.fine(() -> String.format("Max FPS axis value will be %.2f", rhsAxisLimit));
        chart.setYAxisLabel(this.unitsName);
        chart.setYAxisLimit(ylimit);
        chart.setY2AxisLimit(rhsAxisLimit);
        chart.setY2TickCount(rhsAxisTickCount);
        if (this.threshold.isPresent()) {
            double value = this.threshold.get();
            chart.setThreshold(value, this.budgetLabel);
        }
        chart.scaleForSiPrefix();
        chart.setColours(this.needsStreamlineColours);
        return chart;
    }

    public int findDominantSeries() {
        double maxValue = 0.0;
        int maxIndex = 0;
        int i = 0;
        while (i < this.binnedData.getNumSeries() - 1) {
            double sum = this.binnedData.getSeriesStats(i + 1).getSum();
            if (sum > maxValue) {
                maxValue = sum;
                maxIndex = i;
            }
            ++i;
        }
        return maxIndex;
    }

    private double findRhsAxisLimit() {
        int[] preferredMaxValues = new int[]{40, 70, 100};
        if (this.frameMetricSeries.getDisplayMspf()) {
            preferredMaxValues = new int[]{10, 15, 25};
        }
        double rhsLimit = this.binnedData.getSeriesStats(0).getMax();
        int[] nArray = preferredMaxValues;
        int n = preferredMaxValues.length;
        int n2 = 0;
        while (n2 < n) {
            double value = nArray[n2];
            if (rhsLimit < value) {
                rhsLimit = value;
                break;
            }
            ++n2;
        }
        rhsLimit = 10.0 * Math.ceil(rhsLimit / 10.0);
        return rhsLimit;
    }

    private double findYAxisLimit() {
        double ymax = 0.0;
        if (this.binnedData.getNumSeries() > 1) {
            DoubleSummaryStatistics stats = new DoubleSummaryStatistics();
            int i = 1;
            while (i < this.binnedData.getNumSeries()) {
                stats.combine(this.binnedData.getSeriesStats(i));
                ++i;
            }
            double statsMax = stats.getMax();
            if (this.threshold.isPresent()) {
                double thresholdMax = this.threshold.get() * 1.25;
                statsMax = Math.max(thresholdMax, statsMax);
            }
            ymax = 10.0 * Math.ceil(statsMax / 10.0);
        }
        if (ymax == 0.0) {
            ymax = 10.0;
        }
        return ymax;
    }

    private double[] scaleSeriesByFps(double[] data, double[] fpsData) {
        assert (data.length == fpsData.length);
        Application.LOG.fine("Scaling data series for FPS");
        LogUtils.seriesStats(data, "Data series");
        double[] scaled = (double[])data.clone();
        if (this.enableFpsScaling) {
            int i = 0;
            while (i < scaled.length) {
                if (fpsData[i] == 0.0) {
                    scaled[i] = 0.0;
                } else if (scaled[i] > 0.0) {
                    double fps = fpsData[i];
                    int n = i;
                    scaled[n] = scaled[n] / fps;
                } else {
                    scaled[i] = 0.0;
                }
                ++i;
            }
            LogUtils.seriesStats(scaled, "After scale");
        }
        return scaled;
    }
}

