/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.analyser;

import com.arm.streamline.performanceadvisor.Options;
import com.arm.streamline.performanceadvisor.analyser.Analyser;
import com.arm.streamline.performanceadvisor.analyser.AnalyserFactory;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.ProcessProvider;
import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.common.VersionProvider;
import com.arm.streamline.performanceadvisor.section.Element;
import com.arm.streamline.performanceadvisor.section.ElementType;
import com.arm.streamline.performanceadvisor.section.KeyValue;
import com.arm.streamline.performanceadvisor.section.Section;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

public class FooterAnalyserFactory
extends AnalyserFactory {
    @Override
    public Analyser create(CaptureData captureData) {
        return new FooterAnalyser(captureData);
    }

    public class FooterAnalyser
    extends Analyser {
        public FooterAnalyser(CaptureData captureData) {
            super(captureData);
        }

        @Override
        public Section execute(int userRegion) {
            if (userRegion != 0) {
                throw new LogicError("FooterAnalyser can't be applied to a user region");
            }
            List<Element> elements = new ArrayList<Element>();
            elements.add(new Element(ElementType.HORIZONTAL_RULE));
            Options options = this.captureData.getOptions();
            String appName = options.getAppName();
            appName = appName.equals("Performance Advisor Report") ? null : appName;
            KeyValue appNameKeyValue = new KeyValue("Application name", appName);
            if (appName == null) {
                appNameKeyValue.setExcludeFromHtml(true);
            }
            elements.add(appNameKeyValue);
            elements.add(new KeyValue("Capture path", options.getFileNames().get(0)));
            elements.add(new KeyValue("Capture duration", this.captureData.getDuration() + "s"));
            ProcessProvider processProvider = this.captureData.getProcessProvider();
            String processAnalysed = String.format("%s (pid: %d)", processProvider.getName(), processProvider.getPid());
            elements.add(new KeyValue("Process analyzed", processAnalysed));
            elements = this.includeInfoIfPresent(elements, "Package name", options.getPackageName(), this.captureData.getPackageName());
            elements = this.includeInfoIfPresent(elements, "Activity name", options.getActivityName(), this.captureData.getActivityName());
            elements = this.includeInfoIfPresent(elements, "Activity arguments", options.getActivityArguments(), this.captureData.getActivityArguments());
            elements.add(new KeyValue("Report generated at", LocalDateTime.now().format(DateTimeFormatter.ofPattern("dd MMM yyyy HH:mm"))));
            VersionProvider versionProvider = new VersionProvider();
            elements.add(new KeyValue("Version", versionProvider.getShortVersion()));
            return new Section("captureInfo", elements);
        }

        private List<Element> includeInfoIfPresent(List<Element> elements, String keyName, String userValue, String captureValue) {
            if (userValue != null && !userValue.isEmpty()) {
                elements.add(new KeyValue(keyName, userValue));
            } else if (captureValue != null && !captureValue.isEmpty()) {
                elements.add(new KeyValue(keyName, captureValue));
            }
            return elements;
        }
    }
}

