/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.analyser;

import com.arm.streamline.performanceadvisor.analyser.Analyser;
import com.arm.streamline.performanceadvisor.analyser.AnalyserDecorator;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.report.SectionDefinition;
import com.arm.streamline.performanceadvisor.section.Section;

public class FixedFunctionAnalyser
extends AnalyserDecorator {
    private SectionDefinition sectionDefn;
    private String chartName;

    public FixedFunctionAnalyser(Analyser analyser, SectionDefinition sectionDefn) {
        super(analyser);
        this.sectionDefn = sectionDefn;
        this.chartName = sectionDefn.getChartName();
    }

    @Override
    public ProblemList initialise() {
        ProblemList problemList = new ProblemList();
        if (this.sectionDefn.getTitle().isPresent()) {
            problemList.addWarning(this.chartName + ": chart title will be ignored");
        }
        if (this.sectionDefn.getDescription().isPresent()) {
            problemList.addWarning(this.chartName + ": chart description will be ignored");
        }
        if (this.sectionDefn.getThreshold().isPresent()) {
            problemList.addWarning(this.chartName + ": threshold will be ignored");
        }
        problemList.addAll(this.analyser.initialise());
        return problemList;
    }

    @Override
    public Section execute(int userRegion) {
        return this.analyser.execute(userRegion);
    }
}

