/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.analyser;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.analyser.Analyser;
import com.arm.streamline.performanceadvisor.analyser.AnalyserDecorator;
import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.section.Section;
import java.util.HashMap;

public class CachingAnalyser
extends AnalyserDecorator {
    private HashMap<Integer, Section> output = new HashMap();
    private ProblemList problemList = new ProblemList();
    private boolean isInitialised = false;

    public CachingAnalyser(Analyser analyser) {
        super(analyser);
    }

    @Override
    public ProblemList initialise() {
        if (!this.isInitialised) {
            Application.LOG.fine(() -> String.format("%s.initialise()", this.name()));
            this.problemList = this.analyser.initialise();
            this.isInitialised = true;
        }
        return this.problemList;
    }

    @Override
    public Section execute(int userRegion) {
        Section section;
        Application.LOG.fine(() -> String.format("%s.execute(%d)", this.name(), userRegion));
        if (this.isEnabled()) {
            if (!this.isInitialised) {
                throw new LogicError("execute: Analyser " + this.name() + " is not initialised");
            }
            if (this.problemList.hasError()) {
                throw new LogicError("execute: Analyser " + this.name() + " reported errors and so can't be executed");
            }
            if (!this.output.containsKey(userRegion)) {
                section = this.analyser.execute(userRegion);
                this.output.put(userRegion, section);
            } else {
                section = this.output.get(userRegion);
            }
        } else {
            section = new Section();
        }
        return section;
    }
}

