/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor;

import com.arm.streamline.performanceadvisor.Options;
import com.arm.streamline.performanceadvisor.ReportDriver;
import com.arm.streamline.performanceadvisor.common.FatalError;
import com.arm.streamline.performanceadvisor.io.DefaultFileName;
import com.arm.streamline.performanceadvisor.io.FileUtils;
import com.arm.streamline.performanceadvisor.io.PathValidation;
import com.arm.streamline.performanceadvisor.io.UserProvidedPath;
import com.arm.streamline.performanceadvisor.json.JsonDiffReport;
import com.arm.streamline.performanceadvisor.json.JsonDiffReportFileWriter;
import com.arm.streamline.performanceadvisor.json.JsonReport;
import com.arm.streamline.performanceadvisor.json.JsonReportFileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public class DiffDriver
implements ReportDriver {
    private static final String IO_EXCEPTION_MESSAGE = "Error reading input files, please check the filenames are correct";
    private Options options;
    private UserProvidedPath outputPath;
    private UserProvidedPath previousInputPath;
    private UserProvidedPath currentInputPath;

    @Override
    public void validate(Options options) {
        this.options = options;
        this.validateAndSetOutputPath();
        this.validateAndSetInputPaths();
        this.checkOutputLocationIsUniqueFromInputLocations();
    }

    @Override
    public void generate() {
        JsonDiffReport jsonDiffReport;
        JsonReportFileReader reader = new JsonReportFileReader();
        JsonReport previousJsonReport = reader.read(this.previousInputPath);
        JsonReport currentJsonReport = reader.read(this.currentInputPath);
        try {
            jsonDiffReport = currentJsonReport.diff(previousJsonReport);
        }
        catch (IllegalArgumentException e) {
            throw new FatalError("Invalid arguments for diff report, ensure report sections are equal.");
        }
        JsonDiffReportFileWriter diffReportFileWriter = new JsonDiffReportFileWriter();
        diffReportFileWriter.setPrettyPrint(this.options.getPrettyPrint());
        diffReportFileWriter.write(this.outputPath, jsonDiffReport);
        System.out.println("Json diff report written to " + String.valueOf(this.outputPath.getAdjustedPath()));
    }

    private void validateAndSetOutputPath() {
        Path filePath = this.options.getDiffReportFilePath().orElse(Path.of(DefaultFileName.nameWithTimestamp("diff", "json"), new String[0]));
        if (filePath == null || filePath.toString().isEmpty()) {
            throw new FatalError("Diff report output name is missing");
        }
        this.outputPath = UserProvidedPath.combine(this.options.getOutputDirectory(), filePath);
        FileUtils.createMissingDirectories(this.outputPath);
        PathValidation.fatalErrorIfInvalidForFileWrite(this.outputPath);
    }

    private void validateAndSetInputPaths() {
        this.options.validateFilenameCount(2, "Provide two JSON reports.");
        List<String> fileNames = this.options.getFileNames();
        this.previousInputPath = new UserProvidedPath(Paths.get(fileNames.get(0), new String[0]));
        PathValidation.fatalErrorIfInvalidReadableFile(this.previousInputPath);
        this.currentInputPath = new UserProvidedPath(Paths.get(fileNames.get(1), new String[0]));
        PathValidation.fatalErrorIfInvalidReadableFile(this.currentInputPath);
        this.validateInputsAreUniqueLocations();
    }

    private void checkOutputLocationIsUniqueFromInputLocations() {
        if (Files.exists(this.outputPath.getAdjustedPath(), new LinkOption[0])) {
            try {
                boolean diffOutputSameAsCurrJsonReportInput = this.outputPath.refersToSamePathAs(this.currentInputPath);
                boolean diffOutputSameAsPrevJsonReportInput = this.outputPath.refersToSamePathAs(this.previousInputPath);
                if (diffOutputSameAsCurrJsonReportInput || diffOutputSameAsPrevJsonReportInput) {
                    throw new FatalError("Ensure diff report output filename is not the same as either input file");
                }
            }
            catch (IOException e) {
                throw new FatalError(IO_EXCEPTION_MESSAGE);
            }
        }
    }

    private void validateInputsAreUniqueLocations() {
        try {
            boolean currSameAsPrevJsonReport = FileUtils.isSameFile(this.previousInputPath.getAdjustedPath(), this.currentInputPath.getAdjustedPath());
            if (currSameAsPrevJsonReport) {
                System.out.println("WARNING: Both input files refer to the same file");
            }
        }
        catch (IOException e) {
            throw new FatalError(IO_EXCEPTION_MESSAGE);
        }
    }
}

