/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.perf.transform;

import com.arm.streamline.perf.InvalidPerfDataException;
import com.arm.streamline.perf.data_file.HeaderFlags;
import com.arm.streamline.perf.data_file.IDataFile;
import com.arm.streamline.perf.data_file.header_flag_values.BuildIdRecord;
import com.arm.streamline.perf.io.StringIO;
import com.arm.streamline.perf.misc.IParallelEventRecordProcessor;
import com.arm.streamline.perf.records.EventHeader;
import com.arm.streamline.perf.records.RecordBlob;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class CommEntry {
    private final @NonNull String comm;
    private final @NonNull String filename;
    private final int pid;
    private final int tid;
    private final long timestamp;

    protected CommEntry(int pid, int tid, @NonNull String comm, @NonNull String filename, long timestamp) {
        this.pid = pid;
        this.tid = tid;
        this.comm = comm;
        this.filename = filename;
        this.timestamp = timestamp;
    }

    public @NonNull String getComm() {
        return this.comm;
    }

    public @NonNull String getImage() {
        return this.filename;
    }

    public int getPid() {
        return this.pid;
    }

    public int getTid() {
        return this.tid;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return String.format("CommEntry [comm=%s, filename=%s, pid=%s, tid=%s, timestamp=%s]", this.comm, this.filename, this.pid, this.tid, this.timestamp);
    }

    public static class CommEntryBuilder
    implements IParallelEventRecordProcessor<List<CommEntry>> {
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull RecordBlob.IIdToAttributeMap attributesById;
        private final @Nullable List<@NonNull BuildIdRecord> buildIdRecords;
        private final @NonNull IDataFile dataFile;
        private final @NonNull Map<String, String> filenames = new HashMap<String, String>();
        private final long idBits;
        private final @NonNull Set<Integer> kmodePids = new HashSet<Integer>();
        private final @NonNull Map<Integer, CommEntry> result = new HashMap<Integer, CommEntry>();

        private static void insertRecord(@NonNull Map<Integer, CommEntry> result, int pid, int tid, @NonNull String comm, @NonNull String filename, long timestamp) {
            Integer key = tid;
            CommEntry entry = result.get(key);
            if (entry == null || entry.getTimestamp() > timestamp) {
                result.put(key, new CommEntry(pid, tid, comm, filename, timestamp));
            }
        }

        private static @NonNull String makeCommIntoFilename(boolean isKmode, @NonNull String comm) {
            return !isKmode ? String.format("/%s", comm) : "";
        }

        private static @NonNull String makeFilenameIntoComm(@NonNull String filename) {
            int index = filename.lastIndexOf(47);
            return index >= 0 && index + 1 < filename.length() ? filename.substring(index + 1) : filename;
        }

        private static void processBuildIdHeader(@NonNull Map<Integer, CommEntry> result, @NonNull Map<String, String> filenames, @Nullable List<@NonNull BuildIdRecord> records) {
            if (records == null) {
                return;
            }
            for (BuildIdRecord record : records) {
                String comm = CommEntryBuilder.makeFilenameIntoComm(record.getFilename());
                filenames.put(comm, record.getFilename());
                if (record.getPid() == -1) continue;
                CommEntryBuilder.insertRecord(result, record.getPid(), record.getPid(), comm, record.getFilename(), Long.MIN_VALUE);
            }
        }

        public CommEntryBuilder(@NonNull IDataFile dataFile, long idBits, // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull RecordBlob.IIdToAttributeMap attributesById) throws IOException, InterruptedException, InvalidPerfDataException {
            this.dataFile = dataFile;
            this.idBits = idBits;
            this.attributesById = attributesById;
            this.buildIdRecords = dataFile.getHeaderFlagValue(HeaderFlags.HEADER_BUILD_ID);
            CommEntryBuilder.processBuildIdHeader(this.result, this.filenames, this.buildIdRecords);
        }

        @Override
        public @NonNull List<@NonNull CommEntry> finish() {
            return new ArrayList<CommEntry>(this.result.values());
        }

        @Override
        public void process(@NonNull RecordBlob r) throws InvalidPerfDataException, IOException, InterruptedException {
            @NonNull EventHeader header = r.getHeader();
            if (header.getType() == 3) {
                RecordBlob.SampleId id = r.parseSampleId(this.dataFile.getByteOrder(), this.idBits, this.attributesById);
                ByteBuffer buffer = this.dataFile.createByteBuffer(r.getPayload());
                int pid = buffer.getInt();
                int tid = buffer.getInt();
                int length = header.getPayloadSizeAsInt() - (8 + id.getSize());
                byte[] commBytes = new byte[length];
                buffer.get(commBytes);
                String comm = StringIO.stripNullTerminator((String)new String(commBytes, StandardCharsets.US_ASCII));
                long timestamp = id.time != null ? id.time : Long.MIN_VALUE;
                String filename = this.filenames.get(comm);
                if (timestamp == 0L || id.attribute == null) {
                    CommEntryBuilder.insertRecord(this.result, pid, tid, comm, filename != null ? filename : CommEntryBuilder.makeCommIntoFilename(this.kmodePids.contains(pid), comm), timestamp);
                }
            } else if (header.getType() == 7) {
                ByteBuffer buffer = this.dataFile.createByteBuffer(r.getPayload());
                int pid = buffer.getInt();
                int ppid = buffer.getInt();
                int tid = buffer.getInt();
                int ptid = buffer.getInt();
                long time = buffer.getLong();
                if (time == 0L && pid != 1 && (ppid == 0 || this.kmodePids.contains(ppid))) {
                    this.kmodePids.add(pid);
                }
            }
        }
    }
}

