/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.perf.transform;

import com.arm.streamline.common.xml.counters.Category;
import com.arm.streamline.perf.InvalidPerfDataException;
import com.arm.streamline.perf.apc.EventsXml;
import com.arm.streamline.perf.data_file.HeaderFlags;
import com.arm.streamline.perf.data_file.IDataFile;
import com.arm.streamline.perf.data_file.header_flag_values.CpuTopology;
import com.arm.streamline.perf.misc.IParallelEventRecordProcessor;
import com.arm.streamline.perf.records.EventAttribute;
import com.arm.streamline.perf.records.ReadFormat;
import com.arm.streamline.perf.records.RecordBlob;
import com.arm.utils.NullChecking;
import com.arm.utils.StreamUtils;
import gnu.trove.TCollections;
import gnu.trove.TIntCollection;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ClusterCoreMapping {
    private final @NonNull List<@NonNull TIntSet> coreClusterTopology;
    private final int coreCount;
    private final @NonNull TIntIntMap coreToClusterMap;
    private final @NonNull Map<@NonNull EventAttribute, @NonNull TIntSet> eventToCoreIds;
    private final @NonNull TObjectIntMap<String> pmuToClusters;
    private final @NonNull Map<@NonNull String, @NonNull TIntSet> pmuToCoreIds;

    protected static boolean isHardwareOrRawPMU(int type) {
        return type > 5 || type == 4;
    }

    private static @Nullable String getClusterName(@NonNull EventsXml eventsXml, int clusterId, @Nullable String pmu) {
        if (pmu != null) {
            Category category = eventsXml.findCategoryForPmu(pmu);
            if (category != null) {
                return ((String)NullChecking.neverNull((Object)category.getCounterSetAttribute())).replaceAll("_cnt$", "");
            }
            return pmu;
        }
        return null;
    }

    private static boolean isCpuCore(String name) {
        return name.startsWith("arm_arm11") || name.startsWith("armv7_") || name.startsWith("armv8_") || name.startsWith("krait") || name.startsWith("scorpion") || name.startsWith("x86") || name.equals("cpu");
    }

    private static @NonNull String selectBestPmu(@NonNull String a, @NonNull String b) {
        if (a.equals(b)) {
            return a;
        }
        String nameA = a.toLowerCase();
        String nameB = b.toLowerCase();
        boolean isCpuCoreA = ClusterCoreMapping.isCpuCore(nameA);
        boolean isCpuCoreB = ClusterCoreMapping.isCpuCore(nameB);
        if (isCpuCoreA && !isCpuCoreB) {
            return a;
        }
        if (isCpuCoreB && !isCpuCoreA) {
            return b;
        }
        throw new AssertionError((Object)("Somehow had event mapped to multiple PMUs on same cluster that are both known core PMUs : " + nameA + " vs " + nameB));
    }

    protected ClusterCoreMapping(@NonNull Map<@NonNull String, @NonNull TIntSet> pmuToCoreIds, @NonNull Map<@NonNull EventAttribute, @NonNull TIntSet> eventToCoreIds, @NonNull List<@NonNull TIntSet> coreClusterTopology, @NonNull TObjectIntMap<String> pmuToClusters, @NonNull TIntIntMap coreToClusterMap, int coreCount) {
        this.pmuToCoreIds = pmuToCoreIds;
        this.eventToCoreIds = eventToCoreIds;
        this.coreClusterTopology = coreClusterTopology;
        this.pmuToClusters = pmuToClusters;
        this.coreToClusterMap = coreToClusterMap;
        this.coreCount = coreCount;
    }

    public int getClusterCount() {
        return this.coreClusterTopology.size();
    }

    public @Nullable String getClusterName(@NonNull EventsXml eventsXml, @NonNull EventAttribute eventAttribute) {
        Integer clusterId = this.getEventClusterId(eventAttribute);
        if (clusterId == null) {
            return null;
        }
        return ClusterCoreMapping.getClusterName(eventsXml, clusterId, this.getPmuForClusterId(clusterId));
    }

    public @Nullable String getClusterName(@NonNull EventsXml eventsXml, int clusterId) {
        String pmu = this.getPmuForClusterId(clusterId);
        return ClusterCoreMapping.getClusterName(eventsXml, clusterId, pmu);
    }

    public @NonNull List<@NonNull TIntSet> getCoreClusterTopology() {
        return Collections.unmodifiableList(this.coreClusterTopology);
    }

    public int getCoreCount() {
        return this.coreCount;
    }

    public @NonNull TIntIntMap getCoreToClusterMap() {
        return TCollections.unmodifiableMap((TIntIntMap)this.coreToClusterMap);
    }

    public @Nullable Integer getEventClusterId(@NonNull EventAttribute eventAttribute) {
        TIntSet coreIds = (TIntSet)NullChecking.neverNull((Object)this.eventToCoreIds.get(eventAttribute));
        Integer clusterId = null;
        int[] nArray = coreIds.toArray();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int coreId = nArray[n2];
            int clusterForCore = this.coreToClusterMap.get(coreId);
            if (clusterId != null && clusterId != clusterForCore) {
                return null;
            }
            clusterId = clusterForCore;
            ++n2;
        }
        return clusterId;
    }

    public @NonNull Map<@NonNull EventAttribute, @NonNull TIntSet> getEventToCoreIds() {
        return Collections.unmodifiableMap(this.eventToCoreIds);
    }

    public @NonNull TObjectIntMap<String> getPmuToClusterCores() {
        return TCollections.unmodifiableMap(this.pmuToClusters);
    }

    public @NonNull Map<@NonNull String, @NonNull TIntSet> getPmuToCoreIds() {
        return Collections.unmodifiableMap(this.pmuToCoreIds);
    }

    private @Nullable String getPmuForClusterId(int clusterId) {
        return this.pmuToClusters.keySet().stream().filter(p -> this.pmuToClusters.get(p) == clusterId).reduce(ClusterCoreMapping::selectBestPmu).orElse(null);
    }

    public static class ClusterCoreMappingBuilder
    implements IParallelEventRecordProcessor<ClusterCoreMapping> {
        private static final int NO_CLUSTER = -1;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull RecordBlob.IIdToAttributeMap attributesById;
        private final @NonNull List<@NonNull TIntSet> coreClusterTopology;
        private final @NonNull TIntIntMap coreToClusterMap;
        private final @NonNull IDataFile dataFile;
        private final @NonNull Map<@NonNull EventAttribute, @NonNull TIntSet> eventToCoreIds = new HashMap<EventAttribute, TIntSet>();
        private final long idBits;
        private final @NonNull IntFunction<@NonNull String> pmuMappings;

        private static void addEventIdMapping(@NonNull Map<@NonNull EventAttribute, @NonNull TIntSet> eventToCoreIds, int cpu, @NonNull EventAttribute attr) {
            eventToCoreIds.computeIfAbsent(attr, k -> new TIntHashSet()).add(cpu);
        }

        private static @NonNull List<@NonNull TIntSet> getCoreSets(@NonNull IDataFile dataFile) throws IOException {
            ArrayList<@NonNull TIntSet> result = new ArrayList<TIntSet>();
            CpuTopology cpuToplogy = dataFile.getHeaderFlagValue(HeaderFlags.HEADER_CPU_TOPOLOGY);
            if (cpuToplogy != null) {
                for (String cluster : cpuToplogy.getCores()) {
                    result.add(CpuTopology.parseCores(cluster));
                }
            }
            return result;
        }

        public ClusterCoreMappingBuilder(@NonNull IDataFile dataFile, long idBits, // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull RecordBlob.IIdToAttributeMap attributesById, @NonNull IntFunction<@NonNull String> pmuMappings) throws IOException, InvalidPerfDataException {
            this.dataFile = dataFile;
            this.idBits = idBits;
            this.attributesById = attributesById;
            this.coreClusterTopology = ClusterCoreMappingBuilder.getCoreSets(dataFile);
            this.coreToClusterMap = this.createCoreToClusterMap();
            this.pmuMappings = pmuMappings;
        }

        @Override
        public @NonNull ClusterCoreMapping finish() throws InvalidPerfDataException {
            @NonNull TObjectIntMap<String> pmuToClusters = this.createPmuToClusterCoresMap();
            IntStream coresFromTopology = StreamUtils.of((TIntCollection)this.coreToClusterMap.keySet());
            IntStream coresSeen = this.eventToCoreIds.values().stream().flatMapToInt(StreamUtils::of);
            int coreCount = 1 + IntStream.concat(coresFromTopology, coresSeen).reduce(-1, Math::max);
            HashMap<@NonNull String, @NonNull TIntSet> pmuToCoreIds = new HashMap<String, TIntSet>();
            for (Map.Entry<EventAttribute, TIntSet> entry : this.eventToCoreIds.entrySet()) {
                pmuToCoreIds.computeIfAbsent(this.pmuMappings.apply(entry.getKey().getType()), k -> new TIntHashSet()).addAll((TIntCollection)entry.getValue());
            }
            return new ClusterCoreMapping(pmuToCoreIds, this.eventToCoreIds, this.coreClusterTopology, pmuToClusters, this.coreToClusterMap, coreCount);
        }

        @Override
        public void process(@NonNull RecordBlob record) throws InvalidPerfDataException, IOException, InterruptedException {
            if (record.getHeader().getType() == 9) {
                RecordBlob.SampleRecord sampleRecord = record.parseSampleRecord(this.dataFile.getByteOrder(), this.idBits, this.attributesById);
                this.mapIdsForCoresFromSample(this.attributesById, sampleRecord);
            }
        }

        private void addReadFormatToMaps(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull RecordBlob.IIdToAttributeMap attributesById, int cpu, @NonNull ReadFormat readFormat) throws InvalidPerfDataException {
            long[] lArray = readFormat.getIds();
            int n = lArray.length;
            int n2 = 0;
            while (n2 < n) {
                long readId = lArray[n2];
                EventAttribute readEvent = attributesById.getEventAttributeById(Long.valueOf(readId));
                ClusterCoreMappingBuilder.addEventIdMapping(this.eventToCoreIds, cpu, readEvent);
                ++n2;
            }
        }

        private @NonNull TIntIntMap createCoreToClusterMap() throws InvalidPerfDataException {
            TIntIntHashMap result = new TIntIntHashMap(0, 0.5f, 0, -1);
            int i = 0;
            while (i < this.coreClusterTopology.size()) {
                int clusterId = i;
                if (!this.coreClusterTopology.get(i).forEach(arg_0 -> ClusterCoreMappingBuilder.lambda$4((TIntIntMap)result, clusterId, arg_0))) {
                    throw new InvalidPerfDataException(InvalidPerfDataException.Reason.INVALID_CLUSTER_DATA);
                }
                ++i;
            }
            return result;
        }

        private @NonNull TObjectIntMap<String> createPmuToClusterCoresMap() throws InvalidPerfDataException {
            HashMap<@NonNull Object, @NonNull TIntSet> pmuToCore = new HashMap<Object, TIntSet>();
            if (!this.coreToClusterMap.isEmpty()) {
                TObjectIntHashMap pmuToCluster = new TObjectIntHashMap(this.eventToCoreIds.size(), 0.5f, -1);
                HashSet<@NonNull E> pmusNotFromClusters = new HashSet();
                for (Map.Entry<EventAttribute, TIntSet> entry : this.eventToCoreIds.entrySet()) {
                    int type = entry.getKey().getType();
                    if (!ClusterCoreMapping.isHardwareOrRawPMU(type)) continue;
                    String pmu = this.pmuMappings.apply(type);
                    int currentCluster = pmuToCluster.get((Object)pmu);
                    entry.getValue().forEach(arg_0 -> this.lambda$5(currentCluster, (TObjectIntMap)pmuToCluster, pmu, pmusNotFromClusters, arg_0));
                }
                pmuToCluster.keySet().removeAll(pmusNotFromClusters);
                return pmuToCluster;
            }
            for (Map.Entry<EventAttribute, TIntSet> entry : this.eventToCoreIds.entrySet()) {
                int type = entry.getKey().getType();
                if (!ClusterCoreMapping.isHardwareOrRawPMU(type)) continue;
                String pmu = this.pmuMappings.apply(type);
                pmuToCore.put(pmu, entry.getValue());
            }
            if (pmuToCore.size() > 1) {
                HashSet<@NonNull E> pmusNotFromClusters = new HashSet();
                TIntHashSet coreIds = new TIntHashSet();
                for (TIntSet pmuCores : pmuToCore.values()) {
                    coreIds.addAll((TIntCollection)pmuCores);
                }
                coreIds.forEach(coreId -> {
                    HashSet<@NonNull String> pmusWithEventsFromCore = new HashSet<String>();
                    for (Map.Entry entry : pmuToCore.entrySet()) {
                        if (!((TIntSet)entry.getValue()).contains(coreId)) continue;
                        pmusWithEventsFromCore.add((String)entry.getKey());
                    }
                    if (pmusWithEventsFromCore.size() > 1) {
                        pmusNotFromClusters.addAll(pmusWithEventsFromCore);
                    }
                    return true;
                });
                pmuToCore.keySet().removeAll(pmusNotFromClusters);
            }
            assert (this.coreToClusterMap.isEmpty());
            assert (this.coreClusterTopology.isEmpty());
            TObjectIntHashMap pmuToCluster = new TObjectIntHashMap();
            for (Map.Entry entry : pmuToCore.entrySet()) {
                int clusterId = this.coreClusterTopology.size();
                this.coreClusterTopology.add((TIntSet)new TIntHashSet((TIntCollection)entry.getValue()));
                if (!((TIntSet)entry.getValue()).forEach(coreId -> this.coreToClusterMap.put(coreId, clusterId) == -1)) {
                    throw new AssertionError();
                }
                pmuToCluster.put((Object)((String)entry.getKey()), clusterId);
            }
            return pmuToCluster;
        }

        private void mapIdsForCoresFromSample(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull RecordBlob.IIdToAttributeMap attributesById, // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull RecordBlob.SampleRecord sampleRecord) throws InvalidPerfDataException {
            Long attributeId = sampleRecord.getAttributeId();
            EventAttribute event = sampleRecord.getEventAttribute();
            long sampleType = event.getSampleType();
            if ((sampleType & 0x80L) == 0L) {
                return;
            }
            int cpu = (Integer)NullChecking.neverNull((Object)sampleRecord.cpu);
            ClusterCoreMappingBuilder.addEventIdMapping(this.eventToCoreIds, cpu, event);
            if ((sampleType & 0x10L) != 0L) {
                ReadFormat readFormat = new ReadFormat(attributeId, event.getReadFormat(), sampleRecord.buffer::getLong);
                this.addReadFormatToMaps(attributesById, cpu, readFormat);
            }
        }

        private static /* synthetic */ boolean lambda$4(TIntIntMap tIntIntMap, int n, int coreId) {
            return tIntIntMap.put(coreId, n) == -1;
        }

        private /* synthetic */ boolean lambda$5(int n, TObjectIntMap tObjectIntMap, String string, Set set, int coreId) {
            int clusterForCore = this.coreToClusterMap.get(coreId);
            if (n == -1 || n == clusterForCore) {
                tObjectIntMap.put((Object)string, clusterForCore);
            } else {
                set.add(string);
            }
            return true;
        }
    }
}

