/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.perf.misc;

import com.arm.streamline.perf.InvalidPerfDataException;
import com.arm.streamline.perf.records.EventAttribute;
import com.arm.streamline.perf.records.RecordBlob;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.TLongSet;
import java.io.IOException;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class IdToAttributeMap
implements RecordBlob.IIdToAttributeMap {
    private final @NonNull TLongObjectMap<EventAttribute> toAttributeMap = new TLongObjectHashMap();
    private final @Nullable EventAttribute onlyAttribute;

    public IdToAttributeMap(@NonNull Map<@NonNull EventAttribute, @NonNull TLongSet> attributes) throws IOException {
        this.onlyAttribute = attributes.size() == 1 ? attributes.keySet().iterator().next() : null;
        for (Map.Entry<EventAttribute, TLongSet> entry : attributes.entrySet()) {
            EventAttribute attribute = entry.getKey();
            TLongSet ids = entry.getValue();
            long[] lArray = ids.toArray();
            int n = lArray.length;
            int n2 = 0;
            while (n2 < n) {
                long id = lArray[n2];
                if (this.toAttributeMap.put(id, (Object)attribute) != null) {
                    throw new InvalidPerfDataException(InvalidPerfDataException.Reason.DUPLICATE_IDS);
                }
                ++n2;
            }
        }
    }

    public @NonNull EventAttribute getEventAttributeById(@Nullable Long id) throws InvalidPerfDataException {
        if (id != null) {
            EventAttribute attribute = (EventAttribute)this.toAttributeMap.get(id.longValue());
            if (attribute != null) {
                return attribute;
            }
        } else if (this.onlyAttribute != null) {
            return this.onlyAttribute;
        }
        throw new InvalidPerfDataException(InvalidPerfDataException.Reason.MISSING_ID);
    }
}

