/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.perf.data_file.header_flag_values;

import com.arm.streamline.perf.data_file.HeaderFlags;
import com.arm.streamline.perf.io.StringIO;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public final class PmuMapping {
    private final int type;
    private final @NonNull String name;

    public static @NonNull List<@NonNull PmuMapping> create(@NonNull DataInput input) throws IOException {
        ArrayList<@NonNull PmuMapping> pmus = new ArrayList<PmuMapping>();
        int nr = input.readInt();
        int i = 0;
        while (i < nr) {
            pmus.add(new PmuMapping(input));
            ++i;
        }
        return pmus;
    }

    public PmuMapping(@NonNull DataInput input) throws IOException {
        this.type = input.readInt();
        this.name = StringIO.stripNullTerminator((String)HeaderFlags.readHeaderString(input));
    }

    public boolean equals(Object obj) {
        if (obj instanceof PmuMapping) {
            PmuMapping that = (PmuMapping)obj;
            return this.type == that.type && this.name.equals(that.name);
        }
        return false;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.type;
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return String.format("PmuMapping [type=%s, name=%s]", this.type, this.name);
    }
}

