/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.perf.data_file.header_flag_values;

import com.arm.streamline.perf.data_file.HeaderFlags;
import com.arm.streamline.perf.io.StringIO;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.DataInput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;

public final class CpuTopology {
    private final @NonNull List<@NonNull String> cores;
    private final @NonNull List<@NonNull String> threads;

    public static @NonNull TIntSet parseCores(@NonNull String cores) {
        String[] groups;
        TIntHashSet result = new TIntHashSet();
        String[] stringArray = groups = cores.split(",");
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            String group = stringArray[n2];
            String[] range = group.split("-");
            if (range.length == 1) {
                result.add(Integer.parseInt(range[0]));
            } else if (range.length == 2) {
                int from = Integer.parseInt(range[0]);
                int to = Integer.parseInt(range[1]);
                assert (from <= to);
                int i = from;
                while (i <= to) {
                    result.add(i);
                    ++i;
                }
            } else {
                throw new AssertionError((Object)("Invalid group " + group));
            }
            ++n2;
        }
        return result;
    }

    private static @NonNull List<@NonNull String> fixList(@NonNull List<@NonNull String> list) {
        return Collections.unmodifiableList(list.stream().map(s -> StringIO.stripNullTerminator((String)s)).collect(Collectors.toList()));
    }

    public CpuTopology(@NonNull DataInput input) throws IOException {
        this.cores = CpuTopology.fixList(HeaderFlags.readHeaderStringList(input));
        this.threads = CpuTopology.fixList(HeaderFlags.readHeaderStringList(input));
    }

    public boolean equals(Object obj) {
        if (obj instanceof CpuTopology) {
            CpuTopology that = (CpuTopology)obj;
            return this.cores.equals(that.cores) && this.threads.equals(that.threads);
        }
        return false;
    }

    public @NonNull List<@NonNull String> getCores() {
        return this.cores;
    }

    public @NonNull List<@NonNull String> getThreads() {
        return this.threads;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.cores.hashCode();
        result = 31 * result + this.threads.hashCode();
        return result;
    }

    public String toString() {
        return String.format("CpuTopology [cores=%s, threads=%s]", this.cores, this.threads);
    }
}

