/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.perf.data_file;

import com.arm.streamline.perf.InvalidPerfDataException;
import com.arm.streamline.perf.data_file.HeaderFlags;
import com.arm.streamline.perf.data_file.RecordVisitor;
import com.arm.streamline.perf.records.EventAttribute;
import gnu.trove.set.TLongSet;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface IDataFile
extends Closeable {
    default public @NonNull ByteBuffer createByteBuffer(byte @NonNull [] data) {
        return ByteBuffer.wrap(data).order(this.getByteOrder());
    }

    public @NonNull Map<@NonNull EventAttribute, @NonNull TLongSet> getAttributes();

    public @NonNull ByteOrder getByteOrder();

    public <T> @Nullable T getHeaderFlagValue(@NonNull HeaderFlags<T> var1) throws IOException;

    public long getNumberOfRecords() throws IOException, InvalidPerfDataException, InterruptedException;

    default public @NonNull String getTargetName() throws IOException {
        String cpuDesc = this.getHeaderFlagValue(HeaderFlags.HEADER_CPUDESC);
        String arch = this.getHeaderFlagValue(HeaderFlags.HEADER_ARCH);
        String hostname = this.getHeaderFlagValue(HeaderFlags.HEADER_HOSTNAME);
        if (cpuDesc != null && hostname != null) {
            return cpuDesc + " target at " + hostname;
        }
        if (cpuDesc != null) {
            return cpuDesc;
        }
        if (arch != null && hostname != null) {
            return "Unknown " + arch + " target at " + hostname;
        }
        if (arch != null) {
            return "Unknown " + arch + " target";
        }
        if (hostname != null) {
            return "Unknown target at " + hostname;
        }
        return "Unknown target";
    }

    public boolean isHeaderFlagSet(@NonNull HeaderFlags<?> var1);

    public void processRecords(@NonNull RecordVisitor var1) throws IOException, InvalidPerfDataException, InterruptedException;
}

