/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.perf.data_file;

import com.arm.streamline.perf.data_file.FileSection;
import com.arm.streamline.perf.data_file.HeaderFlags;
import com.arm.streamline.perf.data_file.HeaderType;
import com.arm.utils.datainput.SeekableDataInput;
import com.arm.utils.datainput.StreamUtils;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class Header {
    public static final int MAGIC_BYTES_LENGTH = 8;
    private static final long MAGIC2_VALUE = 3622385352885552464L;
    private static final long MAGIC2_VALUE_SWAPPED = 5784119758258193714L;
    private static final int FLAGS_OFFSET = 72;
    private final @NonNull HeaderType type;
    private final long size;
    private final long attrSize;
    private final @NonNull FileSection attrs;
    private final @NonNull FileSection data;
    private final @NonNull FileSection eventTypes;
    private final int @NonNull [] flags;
    private final @NonNull Map<HeaderFlags<?>, FileSection> flagValueSections;

    public static @Nullable HeaderType validateMagicBytes(byte @NonNull [] magic) {
        if (magic.length == 8) {
            assert (magic.length == 8) : "MAGIC_BYTES_LENGTH changed";
            long magicValue = (long)(magic[0] & 0xFF) << 56 | (long)(magic[1] & 0xFF) << 48 | (long)(magic[2] & 0xFF) << 40 | (long)(magic[3] & 0xFF) << 32 | (long)(magic[4] & 0xFF) << 24 | (long)(magic[5] & 0xFF) << 16 | (long)(magic[6] & 0xFF) << 8 | (long)(magic[7] & 0xFF);
            if (magicValue == 3622385352885552464L) {
                return HeaderType.PERF_VERSION_2_BIG_ENDIAN;
            }
            if (magicValue == 5784119758258193714L) {
                return HeaderType.PERF_VERSION_2_LITTLE_ENDIAN;
            }
        }
        return null;
    }

    public static @Nullable HeaderType validateMagicBytes(@NonNull InputStream inputStream) throws IOException {
        byte[] magic = new byte[8];
        try {
            StreamUtils.readFully((InputStream)inputStream, (byte[])magic);
        }
        catch (EOFException e) {
            return null;
        }
        return Header.validateMagicBytes(magic);
    }

    public Header(@NonNull HeaderType headerType, @NonNull SeekableDataInput input) throws IOException {
        assert (headerType == HeaderType.PERF_VERSION_2_BIG_ENDIAN || headerType == HeaderType.PERF_VERSION_2_LITTLE_ENDIAN);
        this.type = headerType;
        this.size = input.readLong();
        assert (this.size >= 72L) : "Size too small (" + this.size + ")";
        this.attrSize = input.readLong();
        this.attrs = new FileSection((DataInput)input);
        this.data = new FileSection((DataInput)input);
        this.eventTypes = new FileSection((DataInput)input);
        this.flags = new int[(int)(this.size - 72L >>> 2)];
        this.flagValueSections = new HashMap();
        long offset = 72L;
        int i = 0;
        while (i < this.flags.length && offset < this.size) {
            this.flags[i] = input.readInt();
            offset += 4L;
            ++i;
        }
        if (headerType.isBigEndian() && Integer.bitCount(this.flags[0]) < Integer.bitCount(this.flags[1])) {
            int zero = this.flags[0];
            this.flags[0] = this.flags[1];
            this.flags[1] = zero;
            int two = this.flags[2];
            this.flags[2] = this.flags[3];
            this.flags[3] = two;
        }
        assert (this.size - offset == 0L) : "Unexpected trailing bytes";
        input.skipBytes((int)(this.size - offset));
        assert (this.flags[0] != 0) : "No flags are set, normally at least a few are";
        long currentOffset = input.offset();
        offset = Math.max(Math.max(currentOffset, this.attrs.getEnd()), Math.max(this.data.getEnd(), this.eventTypes.getEnd()));
        try {
            input.seek(offset);
            int i2 = 0;
            while (i2 < this.flags.length * 32) {
                if (this.isFlagSet(i2)) {
                    @Nullable HeaderFlags<?> flag = HeaderFlags.getByBit(i2);
                    if (flag != null) {
                        this.flagValueSections.put(flag, new FileSection((DataInput)input));
                    } else {
                        input.skipBytes(16);
                    }
                }
                ++i2;
            }
        }
        finally {
            input.seek(currentOffset);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Header) {
            Header that = (Header)obj;
            return this.size == that.size && this.attrSize == that.attrSize && this.attrs.equals(that.attrs) && this.data.equals(that.data) && this.eventTypes.equals(that.eventTypes) && this.type.equals((Object)that.type) && Arrays.equals(this.flags, that.flags) && this.flagValueSections.equals(that.flagValueSections);
        }
        return false;
    }

    public @NonNull FileSection getAttrs() {
        return this.attrs;
    }

    public long getAttrSize() {
        return this.attrSize;
    }

    public @NonNull FileSection getData() {
        return this.data;
    }

    public @NonNull FileSection getEventTypes() {
        return this.eventTypes;
    }

    public <T> @Nullable T getFlagValue(@NonNull HeaderFlags<T> flag, @NonNull SeekableDataInput input) throws IOException {
        FileSection section = this.flagValueSections.get(flag);
        if (section == null) {
            return null;
        }
        long currentOffset = input.offset();
        try {
            T t = flag.readHeaderValue(input, section);
            return t;
        }
        finally {
            assert (input.offset() <= section.getOffset() + section.getSize()) : "Read too much: " + input.offset() + " vs " + (section.getOffset() + section.getSize());
            input.seek(currentOffset);
        }
    }

    public long getSize() {
        return this.size;
    }

    public @NonNull HeaderType getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (int)(this.attrSize ^ this.attrSize >>> 32);
        result = 31 * result + this.attrs.hashCode();
        result = 31 * result + this.data.hashCode();
        result = 31 * result + this.eventTypes.hashCode();
        result = 31 * result + Arrays.hashCode(this.flags);
        result = 31 * result + this.flagValueSections.hashCode();
        return result;
    }

    public boolean isFlagSet(@NonNull HeaderFlags<?> flag) {
        return this.isFlagSet(flag.bit);
    }

    public boolean isFlagSet(int flag) {
        int word = flag >>> 5;
        int bit = flag & 0x1F;
        return word < this.flags.length ? (this.flags[word] & 1 << bit) != 0 : false;
    }

    public String toString() {
        String flagsString = com.arm.utils.StreamUtils.intSetBitIndexes((int[])this.flags).mapToObj(Integer::toString).collect(Collectors.joining(","));
        return String.format("Header [type=%s, size=%s, attrSize=%s, attrs=%s, data=%s, eventTypes=%s, flags=[%s], flagValueSections=%s]", new Object[]{this.type, this.size, this.attrSize, this.attrs, this.data, this.eventTypes, flagsString, this.flagValueSections});
    }
}

