/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.perf;

import com.arm.streamline.perf.PerfToAPCTransformer;
import com.arm.streamline.perf.misc.ResourceEventsXmlProvider;
import com.arm.streamline.perf.transform.IPerfTransformMonitor;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public class Convert {
    private static final @NonNull String DEFAULT_FILE_NAME = "perf-data.apc";

    public static void main(String[] args) throws Throwable {
        if (args.length < 3 || args.length > 4) {
            Convert.help();
        } else {
            File inputFile = new File(args[1]);
            File outputPath = new File(args[2]);
            String apcName = (String)NullChecking.neverNull((Object)(args.length == 4 ? args[3] : inputFile.getName()));
            Convert.run(inputFile, outputPath, apcName);
        }
    }

    private static void deleteRecursive(@NonNull File dir) {
        File[] children = dir.listFiles();
        if (children != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isDirectory()) {
                    Convert.deleteRecursive(child);
                } else {
                    child.delete();
                }
                ++n2;
            }
        }
        dir.delete();
    }

    private static void help() {
        System.err.println("Convert perf.data into APC directory");
        System.err.println("Usage: convert (-32|-64) <input> <output> [<name>]");
        System.err.println("Where <input> is the path to the 'perf.data' file to transform,");
        System.err.println("and <output> is the path where the APC folder will be created.");
        System.err.println("<name> is the optional name of the APC folder, which defaults to perf-data.apc");
        System.err.println("when not specified.");
        System.exit(-1);
    }

    private static void run(@NonNull File inputFile, @NonNull File outputPath, @NonNull String apcName) throws Throwable {
        if (!inputFile.exists() || !inputFile.isFile()) {
            throw new IOException("Invalid input file: " + String.valueOf(inputFile));
        }
        if (!outputPath.exists() || !outputPath.isDirectory()) {
            throw new IOException("Invalid output path: " + String.valueOf(outputPath));
        }
        File apcDirectory = new File(outputPath, (String)(apcName.endsWith(".apc") ? apcName : apcName + ".apc")).getCanonicalFile();
        if (!((File)NullChecking.neverNull((Object)apcDirectory.getParentFile())).equals(outputPath.getCanonicalFile())) {
            throw new IOException("Invalid APC name: " + apcName);
        }
        if (apcDirectory.exists()) {
            Convert.deleteRecursive(apcDirectory);
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (PerfToAPCTransformer transformer = PerfToAPCTransformer.create(inputFile, new ResourceEventsXmlProvider());){
                transformer.writeTo(apcDirectory, new IPerfTransformMonitor(){
                    private IPerfTransformMonitor.ProgressStage currentStage = null;
                    private int progress = 0;

                    @Override
                    public void incProgress() {
                        ++this.progress;
                        if (this.progress % 25000 == 0) {
                            System.out.println("               " + this.progress + " events");
                        }
                    }

                    @Override
                    public void setProgress(@NonNull IPerfTransformMonitor.ProgressStage stage, long nEvents) {
                        if (this.currentStage != stage) {
                            this.progress = 0;
                            this.currentStage = stage;
                            switch (stage) {
                                case VALIDATING_INPUT: {
                                    System.out.println("Validating input");
                                    break;
                                }
                                case WRITING_APC: {
                                    System.out.println("Writing APC data: 0 events");
                                    break;
                                }
                                case EXAMINE_RECORDS: {
                                    System.out.println("Examining records: 0 events");
                                    break;
                                }
                                case MAPPING_ATTRIBUTES_TO_IDS: {
                                    System.out.println("Mapping attributes to IDs");
                                    break;
                                }
                                case PARSING_TRACING_DATA: {
                                    System.out.println("Parsing tracing data section");
                                    break;
                                }
                                case COUNT_EVENT_RECORDS: {
                                    System.out.println("Counting records");
                                    break;
                                }
                            }
                        }
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable t) {
            System.err.println("Removing incomplete APC directory " + String.valueOf(apcDirectory));
            if (apcDirectory.exists()) {
                Convert.deleteRecursive(apcDirectory);
            }
            throw t;
        }
    }
}

