/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.pa;

import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;

public class CmdProgressMonitor
extends NullProgressMonitor {
    private int count = 0;
    private int currentBlocks = 0;
    private int totalWork = 0;
    private boolean show;

    public CmdProgressMonitor(boolean show) {
        this.show = show;
    }

    public void beginTask(@Nullable String name, int totalWork) {
        this.totalWork = totalWork;
        this.count = 0;
    }

    public void worked(int work) {
        if (this.show) {
            this.count += work;
            double percent = (double)this.count / (double)this.totalWork * 100.0;
            double blocks = 0.25 * percent;
            int block = (int)Math.round(blocks);
            if (block != this.currentBlocks && block != -1 && this.totalWork != 0) {
                if (block == 25 && this.currentBlocks == 0) {
                    return;
                }
                if (block == 0 && this.currentBlocks > 0) {
                    System.out.println();
                } else {
                    System.out.print("\r");
                }
                System.out.print("[");
                int i = 0;
                while (i < 25) {
                    if (i < block) {
                        System.out.print("#");
                    } else {
                        System.out.print("-");
                    }
                    ++i;
                }
                System.out.print("]");
                this.currentBlocks = block;
            }
        }
    }

    public void done() {
        if (this.show) {
            System.out.println();
        }
    }
}

