/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.timeline;

import com.arm.streamline.analysis.model.threads.IUniqueThread;
import com.arm.utils.collections.Pair;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ProcessData {
    private final int mIndex;
    private final int mUID;
    private final int mPID;
    private @NonNull String mProcessName;
    private boolean mExited;
    private final @Nullable IUniqueThread mProcess;

    public ProcessData(int index, int uid, @NonNull IUniqueThread process, @NonNull String processName) {
        this.mIndex = index;
        this.mUID = uid;
        this.mPID = process.getOriginalID();
        this.mProcess = process;
        this.mProcessName = processName;
    }

    public ProcessData(int index, int uid, int pid, @NonNull String processName) {
        this.mIndex = index;
        this.mUID = uid;
        this.mPID = pid;
        this.mProcess = null;
        this.mProcessName = processName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ProcessData) {
            return this.mUID == ((ProcessData)obj).mUID;
        }
        return false;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public int getProcessID() {
        return this.mPID;
    }

    public @Nullable IUniqueThread getProcess() {
        return this.mProcess;
    }

    public @NonNull String getProcessName() {
        return this.mProcessName;
    }

    public int getUID() {
        return this.mUID;
    }

    public boolean hasExited() {
        return this.mExited;
    }

    public int hashCode() {
        return this.mUID;
    }

    public void setExited(boolean exited) {
        this.mExited = exited;
    }

    public void setProcessName(@NonNull String processName) {
        this.mProcessName = processName;
    }

    public @NonNull Pair<@NonNull String, @NonNull Integer> getNameAndPid() {
        return new Pair((Object)this.mProcessName, (Object)this.mPID);
    }
}

