/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.session;

import com.arm.streamline.model.session.SessionModelMessages;

public enum EnergyCaptureType {
    NONE{

        public String toString() {
            return SessionModelMessages.NO_ENERGY_COLLECTION_TITLE;
        }
    }
    ,
    ENERGY_PROBE{

        public String toString() {
            return SessionModelMessages.ENERGY_PROBE_TITLE;
        }
    }
    ,
    NIDAQ{

        @Override
        public String getCommand() {
            return "--daq";
        }

        public String toString() {
            return SessionModelMessages.NIDAQ_TITLE;
        }
    };


    public static EnergyCaptureType get(String text) {
        if (text != null) {
            EnergyCaptureType[] energyCaptureTypeArray = EnergyCaptureType.values();
            int n = energyCaptureTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                EnergyCaptureType one = energyCaptureTypeArray[n2];
                if (text.equalsIgnoreCase(one.name())) {
                    return one;
                }
                ++n2;
            }
        }
        return NONE;
    }

    public String getCommand() {
        return null;
    }

    public boolean hasCommand() {
        return this.getCommand() != null;
    }
}

