/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.session;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.model.session.EnergyCaptureChannel;
import com.arm.streamline.model.session.EnergyCaptureType;
import com.arm.streamline.model.session.Session;
import com.arm.streamline.model.session.SessionModelMessages;
import com.arm.streamline.utility.text.VariableResolver;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;

public class EnergyCaptureSettings {
    public static final int DEFAULT_PORT = 8081;
    public static final int MAX_CHANNELS = 40;
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_COMMAND_PATH = "command_path";
    private static final String ATTR_DEVICE_PATH = "device_path";
    private static final String ATTR_PORT = "port";
    private static final String TAG_CHANNEL = "channel";
    private static final int MINIMUM_VERSION = 1;
    private static final int CURRENT_VERSION = 1;
    private String mCommandPath;
    private String mDevicePath;
    private int mPort;
    private EnergyCaptureType mType;
    private EnergyCaptureChannel[] mChannels = new EnergyCaptureChannel[40];

    public static String getDefaultCommandPath() {
        return StreamlinePlugin.getExecutable("caiman").getAbsolutePath();
    }

    public EnergyCaptureSettings() {
        this.resetToDefaults(true);
    }

    public EnergyCaptureSettings(EnergyCaptureSettings other) {
        this.copyFrom(other);
    }

    public EnergyCaptureSettings(XMLParser in, boolean reverseResolve) throws IOException {
        String tag;
        this.resetToDefaults(false);
        String marker = in.getMarker();
        int version = in.getIntegerAttribute(ATTR_VERSION, 0);
        if (version < 1 || version > 1) {
            throw new IOException(MessageFormat.format(SessionModelMessages.INVALID_VERSION, NumberUtils.format((long)version)));
        }
        String path = in.getAttribute(ATTR_COMMAND_PATH, "");
        if (reverseResolve) {
            path = VariableResolver.reverseResolve(path);
        }
        this.setCommandPath(path);
        this.mDevicePath = in.getAttribute(ATTR_DEVICE_PATH, "");
        this.mPort = in.getIntegerAttribute(ATTR_PORT, 8081);
        this.mType = EnergyCaptureType.get(in.getAttribute(ATTR_TYPE));
        while ((tag = in.nextTag(marker)) != null) {
            if (TAG_CHANNEL.equals(tag)) {
                EnergyCaptureChannel channel;
                this.mChannels[channel.getID()] = channel = new EnergyCaptureChannel(in);
                continue;
            }
            in.skip();
        }
    }

    public void copyFrom(EnergyCaptureSettings other) {
        this.mCommandPath = other.mCommandPath;
        this.mDevicePath = other.mDevicePath;
        this.mType = other.mType;
        this.mPort = other.mPort;
        int i = 0;
        while (i < 40) {
            this.mChannels[i] = new EnergyCaptureChannel(other.mChannels[i]);
            ++i;
        }
    }

    public EnergyCaptureChannel getChannel(int index) {
        return this.mChannels[index];
    }

    public EnergyCaptureChannel[] getChannels() {
        return this.mChannels;
    }

    public String[] getCommandLine(String capturePath) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(new File(this.getResolvedCommandPath()).getAbsolutePath());
        if (this.mType.hasCommand()) {
            args.add(this.mType.getCommand());
        }
        if (!this.mDevicePath.isEmpty()) {
            args.add("-d");
            args.add(this.mDevicePath);
        }
        if (this.mPort != 8081) {
            args.add("-p");
            args.add(Integer.toString(this.mPort));
        }
        EnergyCaptureChannel[] energyCaptureChannelArray = this.mChannels;
        int n = this.mChannels.length;
        int n2 = 0;
        while (n2 < n) {
            EnergyCaptureChannel channel = energyCaptureChannelArray[n2];
            if (channel.shouldCapture()) {
                args.add("-r");
                args.add(channel.getID() + ":" + channel.getResistance());
            }
            ++n2;
        }
        args.add(new File(capturePath).getAbsolutePath());
        args.add("--no-print-messages");
        return args.toArray(new String[args.size()]);
    }

    public String getCommandPath() {
        return this.mCommandPath;
    }

    public String getDevicePath() {
        return this.mDevicePath;
    }

    public int getPort() {
        return this.mPort;
    }

    public String getResolvedCommandPath() {
        if (this.mCommandPath.isEmpty()) {
            return EnergyCaptureSettings.getDefaultCommandPath();
        }
        return this.mCommandPath;
    }

    public EnergyCaptureType getType() {
        return this.mType;
    }

    public void resetToDefaults(boolean enableChannel0Power) {
        this.mCommandPath = "";
        this.mDevicePath = "";
        this.mPort = 8081;
        this.mType = EnergyCaptureType.NONE;
        int i = 0;
        while (i < 40) {
            this.mChannels[i] = new EnergyCaptureChannel(i);
            ++i;
        }
        if (enableChannel0Power) {
            this.mChannels[0].setCollectPower(true);
        }
    }

    public void save(String tag, XMLGenerator xml, boolean resolvePaths) throws IOException {
        xml.startTag(tag);
        xml.addAttribute(ATTR_VERSION, 1);
        String path = this.mCommandPath;
        if (resolvePaths) {
            if (path.isEmpty()) {
                path = EnergyCaptureSettings.getDefaultCommandPath();
            }
            path = Session.sanitizePath(path, true);
        }
        xml.addAttributeNotEmpty(ATTR_COMMAND_PATH, path);
        xml.addAttributeNotEmpty(ATTR_DEVICE_PATH, this.mDevicePath);
        if (this.mPort != 8081) {
            xml.addAttribute(ATTR_PORT, this.mPort);
        }
        xml.addAttribute(ATTR_TYPE, this.mType.name().toLowerCase());
        EnergyCaptureChannel[] energyCaptureChannelArray = this.mChannels;
        int n = this.mChannels.length;
        int n2 = 0;
        while (n2 < n) {
            EnergyCaptureChannel channel = energyCaptureChannelArray[n2];
            channel.save(TAG_CHANNEL, xml);
            ++n2;
        }
        xml.endTag();
    }

    public void setCommandPath(String path) {
        this.mCommandPath = FilePath.getPathForPlatform((String)path).equals(FilePath.getPathForPlatform((String)EnergyCaptureSettings.getDefaultCommandPath())) ? "" : path;
    }

    public void setDevicePath(String path) {
        this.mDevicePath = path;
    }

    public void setPort(int port) {
        this.mPort = port;
    }

    public void setType(EnergyCaptureType type) {
        this.mType = type;
    }

    public boolean shouldCapture() {
        if (this.mType != EnergyCaptureType.NONE) {
            EnergyCaptureChannel[] energyCaptureChannelArray = this.mChannels;
            int n = this.mChannels.length;
            int n2 = 0;
            while (n2 < n) {
                EnergyCaptureChannel channel = energyCaptureChannelArray[n2];
                if (channel.shouldCapture()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

