/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.session;

import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.model.session.SessionModelMessages;
import java.io.IOException;

public class EnergyCaptureChannel {
    public static final int DEFAULT_RESISTANCE = 20;
    private static final String ATTR_ID = "id";
    private static final String ATTR_RESISTANCE = "resistance";
    private static final String ATTR_POWER = "power";
    private static final String ATTR_VOLTAGE = "voltage";
    private static final String ATTR_CURRENT = "current";
    private static final String ATTR_ENERGY = "energy";
    private int mID;
    private int mResistance;
    private boolean mCollectPower;
    private boolean mCollectVoltage;
    private boolean mCollectCurrent;
    private boolean mCollectEnergy;

    public EnergyCaptureChannel(EnergyCaptureChannel other) {
        this.mID = other.mID;
        this.mResistance = other.mResistance;
        this.mCollectPower = other.mCollectPower;
        this.mCollectVoltage = other.mCollectVoltage;
        this.mCollectCurrent = other.mCollectCurrent;
        this.mCollectEnergy = other.mCollectEnergy;
    }

    public EnergyCaptureChannel(int id) {
        this.mID = id;
        this.mResistance = 20;
    }

    public EnergyCaptureChannel(XMLParser in) throws IOException {
        this.mID = in.getIntegerAttribute(ATTR_ID, -1);
        if (this.mID < 0 || this.mID >= 40) {
            throw new IOException(SessionModelMessages.INVALID_CHANNEL_ID);
        }
        this.mResistance = in.getIntegerAttribute(ATTR_RESISTANCE, 0);
        if (this.mResistance <= 0) {
            throw new IOException(SessionModelMessages.INVALID_RESISTANCE);
        }
        this.mCollectPower = in.isAttributeSet(ATTR_POWER, false);
        this.mCollectVoltage = in.isAttributeSet(ATTR_VOLTAGE, false);
        this.mCollectCurrent = in.isAttributeSet(ATTR_CURRENT, false);
        this.mCollectEnergy = in.isAttributeSet(ATTR_ENERGY, false);
        in.skip();
    }

    public int getID() {
        return this.mID;
    }

    public int getResistance() {
        return this.mResistance;
    }

    public boolean isCollectCurrent() {
        return this.mCollectCurrent;
    }

    public boolean isCollectEnergy() {
        return this.mCollectEnergy;
    }

    public boolean isCollectPower() {
        return this.mCollectPower;
    }

    public boolean isCollectVoltage() {
        return this.mCollectVoltage;
    }

    public void save(String tag, XMLGenerator xml) throws IOException {
        if (this.mResistance != 20 || this.shouldCapture()) {
            xml.startEmptyTag(tag);
            xml.addAttribute(ATTR_ID, this.mID);
            xml.addAttribute(ATTR_RESISTANCE, this.mResistance);
            xml.addAttributeNot(ATTR_POWER, this.mCollectPower, false);
            xml.addAttributeNot(ATTR_VOLTAGE, this.mCollectVoltage, false);
            xml.addAttributeNot(ATTR_CURRENT, this.mCollectCurrent, false);
            xml.addAttributeNot(ATTR_ENERGY, this.mCollectEnergy, false);
        }
    }

    public void setCollectCurrent(boolean collect) {
        this.mCollectCurrent = collect;
    }

    public void setCollectEnergy(boolean collect) {
        this.mCollectEnergy = collect;
    }

    public void setCollectPower(boolean collect) {
        this.mCollectPower = collect;
    }

    public void setCollectVoltage(boolean collect) {
        this.mCollectVoltage = collect;
    }

    public void setResistance(int resistance) {
        this.mResistance = resistance;
    }

    public boolean shouldCapture() {
        return this.mCollectPower || this.mCollectVoltage || this.mCollectCurrent || this.mCollectEnergy;
    }
}

