/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.process;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.Focus;
import com.arm.streamline.model.RGBString;
import com.arm.streamline.model.annotation.AnnotationTimesliceData;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.process.ITimelineRowProvider;
import com.arm.streamline.model.process.MapData;
import com.arm.streamline.model.process.ThreadAnnotation;
import com.arm.streamline.model.process.TimelineMap;
import com.arm.streamline.model.process.TimelineMapMode;
import com.arm.streamline.model.process.TimelineRowType;
import com.arm.streamline.report.model.CallPathNodeType;
import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.streamline.report.model.uids.IUniqueLifetimes;
import com.arm.utils.NullChecking;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TimelineRow
implements ITimelineRowProvider {
    private static final int[] REASON_MAP = new int[]{-2, -3, -4};
    private final @Nullable TimelineMap mTimelineMap;
    private final @NonNull TimelineRowType mRowType;
    private final @Nullable TimelineRow mParent;
    private final @NonNull List<@NonNull ITimelineRowProvider> mChildren = new ArrayList<ITimelineRowProvider>();
    private @Nullable Pattern mPattern;
    private final @NonNull ICallPath mCallPath;
    private final @NonNull String mName;
    private final int mGroup;
    private final int mChannel;
    private int mThreadHierarchyUID;
    private int mMapPrevStart;
    private int mMapPrevStop;
    private @Nullable ZoomLevel mMapPrevZoomLevel;
    private @Nullable String mMapPrevFocus;
    private @Nullable MapData mMapData;
    private @Nullable List<ThreadAnnotation> mAnnotations;
    private int mAnnotatePrevStart;
    private int mAnnotatePrevStop;
    private @Nullable ZoomLevel mAnnotatePrevZoomLevel;
    private boolean mPassesFilter = true;
    private boolean mOpen = true;
    private final boolean mIsIdle;
    private final boolean mIsKernel;

    public TimelineRow(@NonNull TimelineMap pd, @NonNull Comparator<ICallPath> comparator, @NonNull ICallPath callpath, @NonNull TimelineRowType type, boolean showProcesses) {
        this(pd, comparator, callpath, type, showProcesses, null);
    }

    private TimelineRow(@NonNull TimelineMap pd, @NonNull Comparator<ICallPath> comparator, @NonNull ICallPath callpath, @NonNull TimelineRowType type, boolean showProcesses, @Nullable TimelineRow parent) {
        this.mRowType = type;
        this.mParent = parent;
        this.mTimelineMap = parent == null ? pd : null;
        this.mCallPath = callpath;
        this.mName = this.mCallPath.getName();
        this.mGroup = 0;
        this.mChannel = 0;
        if (type == TimelineRowType.VMUID) {
            assert (callpath.getType() == CallPathNodeType.VMUID);
            this.mIsIdle = false;
            this.mIsKernel = false;
            ArrayList<@NonNull E> processes = new ArrayList(callpath.getChildren());
            Collections.sort(processes, comparator);
            for (ICallPath process : processes) {
                if (!showProcesses) {
                    ArrayList<@NonNull E> threads = new ArrayList(process.getChildren());
                    Collections.sort(threads, comparator);
                    for (ICallPath thread : threads) {
                        TimelineRow t = new TimelineRow(pd, comparator, thread, TimelineRowType.THREAD, false, this);
                        this.mChildren.add(t);
                    }
                    continue;
                }
                TimelineRow t = new TimelineRow(pd, comparator, process, TimelineRowType.PROCESS, false, this);
                this.mChildren.add(t);
            }
        } else if (type == TimelineRowType.PROCESS) {
            boolean skipThreadsRow;
            assert (callpath.getType() == CallPathNodeType.UID);
            @NonNull IUniqueIds uniqueIdMap = pd.getAnalysis().getUniqueIdMap();
            this.mIsIdle = uniqueIdMap.isIdleUID(((Integer)NullChecking.neverNull((Object)callpath.getUniqueID(false))).intValue());
            this.mIsKernel = uniqueIdMap.isKernelUID(((Integer)NullChecking.neverNull((Object)callpath.getUniqueID(false))).intValue());
            ArrayList<@NonNull E> threads = new ArrayList(callpath.getChildren());
            Collections.sort(threads, comparator);
            boolean bl = skipThreadsRow = threads.size() == 1 && ((ICallPath)threads.get(0)).getType() == CallPathNodeType.UID;
            if (skipThreadsRow) {
                this.addGroups((ICallPath)threads.get(0));
            } else {
                for (ICallPath thread : threads) {
                    TimelineRow t = new TimelineRow(pd, comparator, thread, TimelineRowType.THREAD, false, this);
                    this.mChildren.add(t);
                }
            }
        } else if (type == TimelineRowType.THREAD) {
            assert (callpath.getType() == CallPathNodeType.UID);
            @NonNull IUniqueIds uniqueIdMap = pd.getAnalysis().getUniqueIdMap();
            this.mIsIdle = uniqueIdMap.isIdleUID(((Integer)NullChecking.neverNull((Object)callpath.getUniqueID(false))).intValue());
            this.mIsKernel = uniqueIdMap.isKernelUID(((Integer)NullChecking.neverNull((Object)callpath.getUniqueID(false))).intValue());
            this.addGroups(callpath);
        } else {
            throw new AssertionError((Object)type);
        }
    }

    private TimelineRow(@NonNull TimelineRow parent, @NonNull ICallPath callPath, int group) {
        this.mRowType = TimelineRowType.GROUP;
        this.mParent = parent;
        this.mCallPath = callPath;
        this.mGroup = group;
        this.mName = parent.getAnalysis().getAnnotationDataStructure().getGroupName(this.mCallPath.getID(), this.mGroup);
        this.mChannel = 0;
        this.mTimelineMap = null;
        this.mIsIdle = false;
        this.mIsKernel = false;
        this.addChannels(callPath, group);
    }

    private TimelineRow(@NonNull TimelineRow parent, @NonNull ICallPath callPath, int group, int channel) {
        this.mRowType = TimelineRowType.ANNOTATION;
        this.mParent = parent;
        this.mCallPath = callPath;
        this.mGroup = group;
        this.mChannel = channel;
        this.mTimelineMap = null;
        this.mName = parent.getAnalysis().getAnnotationDataStructure().getChannelName(this.mCallPath.getID(), this.mChannel);
        this.mIsIdle = false;
        this.mIsKernel = false;
    }

    @Override
    public @NonNull List<ThreadAnnotation> getAnnotationData(int start, int stop) {
        @NonNull ZoomLevel zoomLevel = this.getAnalysis().getScales().getZoomLevel();
        @Nullable List<ThreadAnnotation> prevAnnotations = this.mAnnotations;
        if (prevAnnotations != null && start == this.mAnnotatePrevStart && stop == this.mAnnotatePrevStop && zoomLevel.equals((Object)this.mAnnotatePrevZoomLevel)) {
            return prevAnnotations;
        }
        List<ThreadAnnotation> list = this.getRowType().isGroup() ? this.getGroupData(start, stop) : (this.getRowType().isAnnotation() ? this.getAnnotatedData(start, stop) : new ArrayList<ThreadAnnotation>());
        this.mAnnotations = list;
        this.mAnnotatePrevZoomLevel = zoomLevel;
        this.mAnnotatePrevStart = start;
        this.mAnnotatePrevStop = stop;
        return list;
    }

    @Override
    public @Nullable List<String> getAnnotationList(int slot) {
        if (this.mRowType == TimelineRowType.GROUP) {
            return this.getGroupSummary(slot);
        }
        if (this.mRowType == TimelineRowType.ANNOTATION) {
            return this.getAnnotationSummary(slot);
        }
        return new ArrayList<String>();
    }

    public @NonNull String getBaseName() {
        @Nullable String name = this.mCallPath.getExtraNameForLink();
        if (name == null) {
            return "";
        }
        int index = name.lastIndexOf(" #");
        if (index == -1) {
            return name;
        }
        return name.substring(0, index);
    }

    @Override
    public @NonNull List<@NonNull ITimelineRowProvider> getChildren() {
        Pattern pattern = this.getTimelineMap().getFilterPattern();
        if (this.mPattern != pattern) {
            for (ITimelineRowProvider row : this.mChildren) {
                row.setPassesFilter(this.mPassesFilter || pattern == null || pattern.matcher(row.getName()).find());
            }
            this.mPattern = pattern;
        }
        return this.mChildren;
    }

    @Override
    public int[] getMapData(int start, int stop) {
        MapData mapObject = this.getMapObject(start, stop);
        if (mapObject != null) {
            if (this.getTimelineMap().getMode() == TimelineMapMode.HEAT_MAP) {
                return mapObject.getProcessData();
            }
            if (this.getTimelineMap().getMode() == TimelineMapMode.CORE_MAP) {
                return mapObject.getCpuData();
            }
            if (this.getTimelineMap().getMode() == TimelineMapMode.CLUSTER_MAP) {
                return mapObject.getClusterData();
            }
            CommonPlugin.error((String)"Invalid TimelineMapMode", (Throwable)new Throwable());
        }
        return new int[0];
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public TimelineRow getParent() {
        return this.mParent;
    }

    @Override
    public TimelineRowType getRowType() {
        return this.mRowType;
    }

    public @NonNull TimelineMap getTimelineMap() {
        @Nullable TimelineRow parent = this.mParent;
        if (parent == null) {
            return (TimelineMap)NullChecking.neverNull((Object)this.mTimelineMap);
        }
        return parent.getTimelineMap();
    }

    @Override
    public int getUID() {
        if (this.mRowType == TimelineRowType.VMUID || this.mRowType == TimelineRowType.PROCESS || this.mRowType == TimelineRowType.THREAD) {
            return this.mCallPath.getID();
        }
        return this.mThreadHierarchyUID;
    }

    @Override
    public boolean isIdle() {
        return this.mIsIdle;
    }

    @Override
    public boolean isKernel() {
        return this.mIsKernel;
    }

    @Override
    public boolean isOpen() {
        return this.mOpen;
    }

    @Override
    public boolean passesFilter() {
        return this.mPassesFilter;
    }

    @Override
    public void setOpenness(boolean open) {
        this.mOpen = open;
    }

    @Override
    public void setPassesFilter(boolean passes) {
        this.mPassesFilter = passes;
    }

    public void setThreadHierarchyUniqueID(int id) {
        this.mThreadHierarchyUID = id;
    }

    private void addChannels(ICallPath callPath, int group) {
        int[] channels;
        int thread = callPath.getID();
        int[] nArray = channels = this.getAnalysis().getAnnotationDataStructure().getChannels(thread);
        int n = channels.length;
        int n2 = 0;
        while (n2 < n) {
            int channel = nArray[n2];
            if (this.getAnalysis().getAnnotationDataStructure().containsChannel(thread, channel, group)) {
                TimelineRow t = new TimelineRow(this, callPath, group, channel);
                this.mChildren.add(t);
            }
            ++n2;
        }
    }

    private void addGroups(@NonNull ICallPath callPath) {
        int[] groups = this.getAnalysis().getAnnotationDataStructure().getGroups(callPath.getID());
        if (groups.length == 1) {
            this.addChannels(callPath, groups[0]);
        } else {
            int[] nArray = groups;
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                int group = nArray[n2];
                TimelineRow t = new TimelineRow(this, callPath, group);
                this.mChildren.add(t);
                ++n2;
            }
        }
    }

    private Analysis getAnalysis() {
        return this.getTimelineMap().getAnalysis();
    }

    private @NonNull List<ThreadAnnotation> getAnnotatedData(int start, int stop) {
        int dataEndIndex = this.getTimelineMap().getAnalysis().getBinCount() - 1;
        ArrayList<ThreadAnnotation> data = new ArrayList<ThreadAnnotation>();
        int id = 1;
        if (stop < start) {
            return data;
        }
        int remainder = stop - dataEndIndex;
        stop = Math.min(stop, dataEndIndex);
        ArrayList<HashMap<ICallPath, AnnotationTimesliceData>> dataBlocks = this.getTimelineMap().getAnnotations().getDataBlocks(start, stop - start + 1);
        for (Map map : dataBlocks) {
            if (map != null) {
                AnnotationTimesliceData current = (AnnotationTimesliceData)map.get(this.mCallPath);
                if (current != null && current.hasChannel(this.mChannel)) {
                    if (current.isStartFrame(this.mChannel)) {
                        ++id;
                    }
                    ThreadAnnotation ta = new ThreadAnnotation(current.getRGB(this.mChannel), current.toString(this.mChannel, ", "), id, current.isStartFrame(this.mChannel), current.isEndFrame(this.mChannel));
                    data.add(ta);
                    continue;
                }
                data.add(null);
                continue;
            }
            data.add(null);
        }
        while (remainder-- > 0) {
            data.add(null);
        }
        return data;
    }

    private List<String> getAnnotationSummary(int slot) {
        AnnotationTimesliceData data;
        if (this.mRowType != TimelineRowType.ANNOTATION) {
            return null;
        }
        ArrayList<String> summaries = new ArrayList<String>();
        int dataEndIndex = this.getTimelineMap().getAnalysis().getBinCount() - 1;
        if (slot > dataEndIndex || slot < 0) {
            return summaries;
        }
        HashMap<ICallPath, AnnotationTimesliceData> hashData = this.getTimelineMap().getAnnotations().getData(slot);
        if (hashData != null && (data = (AnnotationTimesliceData)hashData.get(this.mCallPath)) != null && data.hasChannel(this.mChannel)) {
            ArrayList<RGBString> labels = data.getLabels(this.mChannel);
            for (RGBString label : labels) {
                summaries.add(label.getString());
            }
        }
        return summaries;
    }

    private @NonNull List<ThreadAnnotation> getGroupData(int start, int stop) {
        int dataEndIndex = this.getTimelineMap().getAnalysis().getBinCount() - 1;
        int end = stop - start;
        int id = 1;
        ArrayList<ThreadAnnotation> groupData = new ArrayList<ThreadAnnotation>();
        int index = 0;
        while (index <= end) {
            if (start + index > dataEndIndex) {
                groupData.add(null);
            } else {
                for (ITimelineRowProvider row : this.getChildren()) {
                    ThreadAnnotation threadAnnotation = row.getAnnotationData(start, stop).get(index);
                    if (threadAnnotation == null) continue;
                    if (groupData.size() == index) {
                        groupData.add(threadAnnotation.duplicate(id));
                        continue;
                    }
                    ((ThreadAnnotation)groupData.get(index)).update(threadAnnotation);
                }
                if (groupData.size() == index) {
                    groupData.add(null);
                }
                if (groupData.get(index) != null && ((ThreadAnnotation)groupData.get(index)).isStartFrame()) {
                    ((ThreadAnnotation)groupData.get(index)).setId(++id);
                }
            }
            ++index;
        }
        return groupData;
    }

    private @Nullable List<String> getGroupSummary(int slot) {
        if (this.mRowType != TimelineRowType.GROUP) {
            return null;
        }
        ArrayList<String> summaries = new ArrayList<String>();
        int dataEndIndex = this.getTimelineMap().getAnalysis().getBinCount() - 1;
        if (slot > dataEndIndex || slot < 0) {
            return summaries;
        }
        List<ITimelineRowProvider> children = this.getChildren();
        for (ITimelineRowProvider child : children) {
            summaries.addAll(((TimelineRow)child).getAnnotationSummary(slot));
        }
        return summaries;
    }

    private MapData getMapObject(int start, int stop) {
        if (this.mRowType != TimelineRowType.THREAD && this.mRowType != TimelineRowType.PROCESS) {
            return null;
        }
        int size = stop - start + 1;
        if (size > 0) {
            boolean active = false;
            @NonNull ZoomLevel zoomLevel = this.getAnalysis().getScales().getZoomLevel();
            Focus focus = this.getAnalysis().getFocusObject();
            @NonNull ICaptureDataProvider.IFocusedEventSource fes = this.getAnalysis().getFocusedEventSource();
            int channelCount = fes.getCoreCount();
            if (start == this.mMapPrevStart && stop == this.mMapPrevStop && zoomLevel.equals((Object)this.mMapPrevZoomLevel) && NullChecking.equalsNullable((Object)focus.getFocusSource(), (Object)this.mMapPrevFocus)) {
                return this.mMapData;
            }
            int dataEndIndex = this.getTimelineMap().getAnalysis().getBinCount() - 1;
            start = Math.min(Math.max(0, start), dataEndIndex);
            stop = Math.max(start, Math.min(stop, dataEndIndex));
            int[] thread = new int[size];
            int[] core = new int[size];
            int[] cluster = new int[size];
            Arrays.fill(thread, -1);
            Arrays.fill(core, -1);
            Arrays.fill(cluster, -1);
            @NonNull IUniqueLifetimes threadLife = this.getTimelineMap().getAnalysis().getUniqueLifetimes();
            focus.setAutoCloseFiles(false);
            int i = start;
            while (i <= stop) {
                int percentage = 0;
                int majority = 0;
                int state = 0;
                long currentBinTime = this.getTimelineMap().getAnalysis().getScales().getTimeInNanoseconds(i);
                Map<ICallPath, TIntArrayList> data = focus.getData(i);
                if (this.mRowType == TimelineRowType.PROCESS) {
                    List children = this.mCallPath.getChildren();
                    TIntIntHashMap corePercentage = new TIntIntHashMap();
                    for (ICallPath one : children) {
                        TIntArrayList values;
                        int uid = one.getID();
                        if (data != null && (values = data.get(one)) != null) {
                            int[] nativeArray;
                            int[] nArray = nativeArray = values.toArray();
                            int n = nativeArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                int value = nArray[n2];
                                int p = value & 0xFFFF;
                                int c = value >>> 24;
                                if (p > 0) {
                                    state = 0;
                                } else {
                                    int v = value >> 16 & 0xFF;
                                    if (v > state) {
                                        state = v;
                                    }
                                }
                                corePercentage.adjustOrPutValue(c, p, p);
                                ++n2;
                            }
                        }
                        if (active) continue;
                        boolean bl = active = threadLife.getStartTime(uid).orElse(Long.MAX_VALUE) < currentBinTime && threadLife.getEndTime(uid).orElse(Long.MIN_VALUE) > currentBinTime;
                    }
                    int[] cores = corePercentage.keys();
                    int max = 0;
                    Arrays.sort(cores);
                    int[] value = cores;
                    int n = cores.length;
                    var26_29 = 0;
                    while (var26_29 < n) {
                        int c = value[var26_29];
                        int value2 = corePercentage.get(c);
                        percentage += value2;
                        if (value2 > max) {
                            max = value2;
                            majority = c;
                        }
                        ++var26_29;
                    }
                } else {
                    int uid = this.mCallPath.getID();
                    if (data != null) {
                        TIntArrayList values = data.get(this.mCallPath);
                        int max = 0;
                        if (values != null) {
                            int[] nArray = values.toArray();
                            var26_29 = nArray.length;
                            int n = 0;
                            while (n < var26_29) {
                                int value = nArray[n];
                                int p = value & 0xFFFF;
                                int c = value >>> 24;
                                state = value >> 16 & 0xFF;
                                percentage += p;
                                if (p > max) {
                                    max = p;
                                    majority = c;
                                }
                                ++n;
                            }
                        }
                    }
                    boolean bl = active = threadLife.getStartTime(uid).orElse(Long.MAX_VALUE) < currentBinTime && threadLife.getEndTime(uid).orElse(Long.MIN_VALUE) > currentBinTime;
                }
                if (percentage > 0) {
                    if ((percentage = (percentage + channelCount / 2) / channelCount) == 0) {
                        percentage = 1;
                    }
                    thread[i - start] = percentage;
                    core[i - start] = majority;
                    cluster[i - start] = fes.getClusterID(majority);
                } else if (active) {
                    int reason = -2;
                    if (state >= 0 && state < REASON_MAP.length) {
                        reason = REASON_MAP[state];
                    }
                    thread[i - start] = reason;
                    core[i - start] = reason;
                    cluster[i - start] = reason;
                    active = false;
                } else {
                    thread[i - start] = -1;
                    core[i - start] = -1;
                    cluster[i - start] = -1;
                }
                ++i;
            }
            focus.cleanup();
            focus.setAutoCloseFiles(true);
            this.mMapData = new MapData(thread, core, cluster);
            this.mMapPrevFocus = this.getAnalysis().getFocusSource();
            this.mMapPrevZoomLevel = zoomLevel;
            this.mMapPrevStart = start;
            this.mMapPrevStop = stop;
        } else {
            this.mMapData = new MapData();
        }
        return this.mMapData;
    }

    @Override
    public long getVmEndTimeNs() {
        @Nullable Long vmUID = this.mCallPath.getVmUID(true);
        return this.getAnalysis().getVmEndTimeNs(vmUID != null ? vmUID : 0L);
    }

    @Override
    public long getVmStartTimeNs() {
        @Nullable Long vmUID = this.mCallPath.getVmUID(true);
        return this.getAnalysis().getVmStartTimeNs(vmUID != null ? vmUID : 0L);
    }
}

