/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.process;

import com.arm.streamline.common.model.Scales;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.annotation.Annotations;
import com.arm.streamline.model.process.ITimelineMapProvider;
import com.arm.streamline.model.process.ITimelineRowProvider;
import com.arm.streamline.model.process.TimelineMapMode;
import com.arm.streamline.model.process.TimelineRow;
import com.arm.streamline.model.process.TimelineRowType;
import com.arm.streamline.report.model.CallPathNodeType;
import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.uids.IUniqueIdMap;
import com.arm.utils.NullChecking;
import com.arm.utils.text.NumericStringComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TimelineMap
implements ITimelineMapProvider {
    public static final @NonNull ZoomLevel[] SCALES = Scales.HI_RES_ZOOM_LEVELS;
    private @Nullable ZoomLevel mZoomLevel;
    private final @NonNull Analysis mAnalysis;
    private @Nullable Annotations mAnnotations;
    private final @NonNull List<@NonNull ITimelineRowProvider> mRootRows = new ArrayList<ITimelineRowProvider>();
    private final @NonNull List<@NonNull ITimelineRowProvider> mProcessRows = new ArrayList<ITimelineRowProvider>();
    private @NonNull TimelineMapMode mMapMode = TimelineMapMode.HEAT_MAP;
    private @Nullable Pattern mPattern;

    public TimelineMap(@NonNull Analysis analysis) {
        this.mAnalysis = analysis;
        this.updateScale();
        this.createTimelineRows();
    }

    public Analysis getAnalysis() {
        return this.mAnalysis;
    }

    public Annotations getAnnotations() {
        this.updateScale();
        return this.mAnnotations;
    }

    public Pattern getFilterPattern() {
        return this.mPattern;
    }

    @Override
    public @NonNull List<@NonNull ITimelineRowProvider> getRootTimelineRows() {
        return this.mRootRows;
    }

    @Override
    public @NonNull List<@NonNull ITimelineRowProvider> getProcessLevelTimelineRows() {
        return this.mProcessRows;
    }

    @Override
    public TimelineMapMode getMode() {
        return this.mMapMode;
    }

    @Override
    public void setFilterPattern(Pattern pattern) {
        if (this.mPattern != pattern) {
            for (ITimelineRowProvider row : this.mRootRows) {
                row.setPassesFilter(pattern == null || pattern.matcher(row.getName()).find());
            }
            this.mPattern = pattern;
        }
    }

    @Override
    public void setMode(TimelineMapMode mode) {
        this.mMapMode = mode;
    }

    public void updateScale() {
        @NonNull ZoomLevel zoomLevel = this.getAnalysis().getScales().getZoomLevel();
        if (!zoomLevel.equals((Object)this.mZoomLevel)) {
            this.mZoomLevel = zoomLevel;
            this.mAnnotations = this.getAnalysis().getAnnotations(zoomLevel);
        }
    }

    private void createTimelineRows() {
        int id = 0;
        ArrayList<@NonNull E> roots = new ArrayList(this.mAnalysis.getInstructionCounterModel().getCallPaths().getRootCallPaths());
        CallPathComparator comparator = new CallPathComparator((IUniqueIdMap)this.mAnalysis.getUniqueIdMap());
        Collections.sort(roots, comparator);
        boolean rootIsSingleVm = roots.size() == 1 && ((ICallPath)roots.get(0)).getType() == CallPathNodeType.VMUID;
        boolean showVms = !rootIsSingleVm;
        boolean showProcesses = this.mAnalysis.shouldShowProcesses();
        for (ICallPath root : roots) {
            id = Math.max(id, root.getID());
            switch (root.getType()) {
                case VMUID: {
                    TimelineRow th;
                    if (showVms) {
                        th = new TimelineRow(this, comparator, root, TimelineRowType.VMUID, showProcesses);
                        th.setOpenness(true);
                        this.mRootRows.add(th);
                        this.mProcessRows.addAll(th.getChildren());
                        break;
                    }
                    id = this.createTimelineRowsFromChildren(comparator, id, root, !showProcesses, TimelineRowType.PROCESS);
                    break;
                }
                case UID: {
                    TimelineRow th;
                    if (showProcesses) {
                        th = new TimelineRow(this, comparator, root, TimelineRowType.PROCESS, showProcesses);
                        this.mRootRows.add(th);
                        this.mProcessRows.add(th);
                        break;
                    }
                    id = this.createTimelineRowsFromChildren(comparator, id, root, false, TimelineRowType.THREAD);
                    break;
                }
                default: {
                    throw new AssertionError(root.getType());
                }
            }
        }
        for (ITimelineRowProvider row : this.mRootRows) {
            id = this.createUniqueIDs(row, id);
        }
    }

    private int createTimelineRowsFromChildren(@NonNull Comparator<ICallPath> comparator, int maxId, @NonNull ICallPath node, boolean useChildrenAsThreadsInstead, @NonNull TimelineRowType type) {
        assert (type == TimelineRowType.PROCESS || type == TimelineRowType.THREAD);
        assert (type == TimelineRowType.PROCESS || !useChildrenAsThreadsInstead);
        ArrayList<@NonNull E> children = new ArrayList(node.getChildren());
        Collections.sort(children, comparator);
        for (ICallPath child : children) {
            if (useChildrenAsThreadsInstead) {
                maxId = this.createTimelineRowsFromChildren(comparator, maxId, child, false, TimelineRowType.THREAD);
                continue;
            }
            TimelineRow th = new TimelineRow(this, comparator, child, type, false);
            this.mRootRows.add(th);
            this.mProcessRows.add(th);
            maxId = Math.max(maxId, child.getID());
        }
        return maxId;
    }

    private int createUniqueIDs(ITimelineRowProvider row, int id) {
        if (row.getRowType() == TimelineRowType.ANNOTATION || row.getRowType() == TimelineRowType.GROUP) {
            ((TimelineRow)row).setThreadHierarchyUniqueID(++id);
        }
        for (ITimelineRowProvider child : row.getChildren()) {
            id = this.createUniqueIDs(child, id);
        }
        return id;
    }

    public static final class CallPathComparator
    implements Comparator<ICallPath> {
        private final @NonNull IUniqueIdMap uniqueMap;

        public CallPathComparator(@NonNull IUniqueIdMap uniqueMap) {
            this.uniqueMap = uniqueMap;
        }

        @Override
        public int compare(ICallPath o1, ICallPath o2) {
            switch (o1.getType()) {
                case VMUID: {
                    switch (o2.getType()) {
                        case VMUID: {
                            @NonNull Long vmid1 = (Long)NullChecking.neverNull((Object)o1.getVmUID(false));
                            @NonNull Long vmid2 = (Long)NullChecking.neverNull((Object)o2.getVmUID(false));
                            return vmid1.compareTo(vmid2);
                        }
                        case UID: {
                            return -1;
                        }
                    }
                    throw new AssertionError(o1.getType());
                }
                case UID: {
                    switch (o2.getType()) {
                        case VMUID: {
                            return 1;
                        }
                        case UID: {
                            int totalTimeResult;
                            int uid1 = (Integer)NullChecking.neverNull((Object)o1.getUniqueID(false));
                            int uid2 = (Integer)NullChecking.neverNull((Object)o2.getUniqueID(false));
                            if (this.uniqueMap.isIdleUID(uid1)) {
                                if (!this.uniqueMap.isIdleUID(uid2)) {
                                    return -1;
                                }
                            } else if (this.uniqueMap.isIdleUID(uid2)) {
                                return 1;
                            }
                            if (this.uniqueMap.isKernelUID(uid1)) {
                                if (!this.uniqueMap.isKernelUID(uid2)) {
                                    return -1;
                                }
                            } else if (this.uniqueMap.isKernelUID(uid2)) {
                                return 1;
                            }
                            if ((totalTimeResult = Long.compare(o1.getTotalSamples(), o2.getTotalSamples())) != 0) {
                                return totalTimeResult;
                            }
                            int nameResult = NumericStringComparator.caselessCompareStrings((String)o1.getName(), (String)o2.getName());
                            if (nameResult != 0) {
                                return nameResult;
                            }
                            return o1.compareTo((Object)o2);
                        }
                    }
                    throw new AssertionError(o1.getType());
                }
            }
            throw new AssertionError(o1.getType());
        }
    }
}

