/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.process;

import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.utility.Ternary;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.bindata.IBinDataProvider;
import com.arm.streamline.model.chart.ChartUtility;
import com.arm.streamline.model.chart.SeriesRangeInfo;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;

public class ProcessMemory {
    private Analysis mAnalysis;
    private IBinDataProvider mMemoryUsed;

    public ProcessMemory(Analysis analysis) {
        this.mAnalysis = analysis;
        for (IBinDataProvider provider : this.mAnalysis.getAllBinData().getAllProviders()) {
            if (!provider.getCounterRecord().isMemoryUsed() || provider.getCounterRecord().isProc() != Ternary.TRUE) continue;
            this.mMemoryUsed = provider;
            break;
        }
    }

    public final long getData(int start, int end, int uid) {
        if (!this.isProcessMemoryDataAvailable()) {
            return -1L;
        }
        TIntHashSet tids = this.mAnalysis.getUniqueIdMap().toThreadUids(uid).collect(TIntHashSet::new, TIntSet::add, TIntSet::addAll);
        CounterRecord record = this.mMemoryUsed.getCounterRecord();
        String expression = record.getExpression();
        SeriesRangeInfo info = new SeriesRangeInfo(record.getDisplay(), expression, record.isAverageCores(), record.isAverageSelection(), tids, this.mAnalysis.getCores(record), ChartUtility.getVariableSetFromExpression(expression), ChartUtility.isExpressionComplex(expression));
        return Math.round(this.mAnalysis.getCharts().getAnalysis().getSeriesRangeCalculator().getAggregateRange(info, start, end));
    }

    public final boolean isProcessMemoryDataAvailable() {
        return this.mMemoryUsed != null;
    }
}

