/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.live;

import com.arm.streamline.analysis.model.threads.IUniqueThread;
import com.arm.streamline.model.capture.IProcessListener;
import com.arm.streamline.model.live.ILiveProcessDataProvider;
import com.arm.streamline.model.timeline.ProcessData;
import com.arm.streamline.protocol.capture.apc.pass_two.IUniqueThreadTracker;
import com.arm.streamline.protocol.capture.apc.pass_two.LinuxThreadTracker;
import com.arm.streamline.protocol.misc.AttachedApkEntries;
import com.arm.streamline.protocol.misc.TaskId;
import gnu.trove.iterator.TIntIntIterator;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.ToIntFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class LiveProcessDataProvider
implements ILiveProcessDataProvider {
    private final @NonNull ProcessData idleProcessData;
    private final @NonNull IUniqueThread idleThread;
    private final @NonNull ProcessData kernelProcessData;
    private final @NonNull List<@NonNull ProcessData> processDataList = new ArrayList<ProcessData>();
    private final @NonNull List<@NonNull IProcessListener> processListeners = new ArrayList<IProcessListener>();
    private final @NonNull ToIntFunction<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IUniqueThreadTracker.ITrackedUniqueThread> threadUidAllocator = new ToIntFunction<IUniqueThreadTracker.ITrackedUniqueThread>(){
        private int counter = 1;

        @Override
        public int applyAsInt(IUniqueThreadTracker.ITrackedUniqueThread value) {
            return this.counter++;
        }
    };
    private final @NonNull TIntIntMap uidToCpuActivity = new TIntIntHashMap(0, 0.5f, 0, 0);
    private final @NonNull TIntIntMap uidToPreviousCpuActivity = new TIntIntHashMap(0, 0.5f, 0, 0);
    private final @NonNull TIntObjectMap<ProcessData> uidToProcessDataMap = new TIntObjectHashMap(0, 0.5f, 0);
    private final @NonNull IUniqueThreadTracker uniqueThreadTracker = new LinuxThreadTracker(0L, this.threadUidAllocator, Collections.emptyList(), new AttachedApkEntries(Collections.emptyMap()), false);

    public LiveProcessDataProvider() throws IOException {
        this.idleThread = this.uniqueThreadTracker.track(-1L, new TaskId(0, 0), false);
        assert (this.idleThread.isIdle());
        assert (this.idleThread.isKernel());
        assert (this.idleThread.isProcessThread());
        int kernelUid = this.idleThread.getUID();
        assert (kernelUid == 1);
        this.idleProcessData = new ProcessData(0, 0, this.idleThread, "idle");
        this.kernelProcessData = new ProcessData(1, 1, this.idleThread, "kernel");
        this.processDataList.add(this.idleProcessData);
        this.processDataList.add(this.kernelProcessData);
        this.uidToProcessDataMap.put(0, (Object)this.idleProcessData);
        this.uidToProcessDataMap.put(1, (Object)this.kernelProcessData);
    }

    @Override
    public final synchronized void addProcessListener(@NonNull IProcessListener listener) {
        this.processListeners.add(listener);
    }

    @Override
    public void clearCPUActivity() {
        this.uidToCpuActivity.clear();
    }

    @Override
    public @NonNull IUniqueThread getIdleThread() {
        return this.idleThread;
    }

    @Override
    public long getMemoryUsed(int start, int end, @NonNull ProcessData processData) {
        return 0L;
    }

    @Override
    public int getPercentCPU(int start, int end, @NonNull ProcessData processData) {
        return this.uidToCpuActivity.get(processData.getUID());
    }

    @Override
    public @Nullable ProcessData getProceessData(@NonNull IUniqueThread uniqueThread) {
        int uid = this.getProcessDataUID(uniqueThread);
        return (ProcessData)this.uidToProcessDataMap.get(uid);
    }

    @Override
    public @NonNull List<@NonNull ProcessData> getProcessData() {
        return Collections.unmodifiableList(this.processDataList);
    }

    @Override
    public int getProcessDataUID(@NonNull IUniqueThread uniqueThread) {
        if (uniqueThread.isIdle()) {
            return 0;
        }
        if (uniqueThread.isKernel()) {
            return 1;
        }
        IUniqueThread process = uniqueThread.getProcessThread();
        if (process == null) {
            return -1;
        }
        return process.getUID();
    }

    @Override
    public @NonNull List<@NonNull ProcessData> getSpecificProcessData(String processNameRegex) {
        return Collections.emptyList();
    }

    @Override
    public @NonNull IUniqueThreadTracker getUniqueThreadTracker() {
        return this.uniqueThreadTracker;
    }

    @Override
    public boolean isProcessMemoryDataAvailable() {
        return false;
    }

    @Override
    public void nextBin() {
        int val;
        int uid;
        HashSet<ProcessData> notifySet = new HashSet<ProcessData>();
        TIntIntIterator itr = this.uidToPreviousCpuActivity.iterator();
        while (itr.hasNext()) {
            ProcessData pd;
            itr.advance();
            uid = itr.key();
            val = itr.value();
            if (val == 0 || this.uidToCpuActivity.containsKey(uid) || (pd = (ProcessData)this.uidToProcessDataMap.get(uid)) == null) continue;
            notifySet.add(pd);
        }
        itr = this.uidToCpuActivity.iterator();
        while (itr.hasNext()) {
            ProcessData pd;
            itr.advance();
            uid = itr.key();
            val = itr.value();
            int previous = this.uidToPreviousCpuActivity.get(uid);
            if (val == previous || (pd = (ProcessData)this.uidToProcessDataMap.get(uid)) == null) continue;
            notifySet.add(pd);
        }
        if (!notifySet.isEmpty()) {
            this.notifyListenersProcessChanged(notifySet, true);
        }
        this.uidToPreviousCpuActivity.clear();
        this.uidToPreviousCpuActivity.putAll(this.uidToCpuActivity);
    }

    @Override
    public final synchronized void removeProcessListener(@NonNull IProcessListener listener) {
        this.processListeners.remove(listener);
    }

    @Override
    public void schedSwitch(long time, @NonNull IUniqueThread uniqueThread) {
        this.insertAndUpdateProcess(uniqueThread);
    }

    @Override
    public void setCPUActivityValue(@NonNull IUniqueThread uniqueThread, int percentage) {
        int uid = this.getProcessDataUID(uniqueThread);
        if (uid != -1 && uid != 0) {
            this.uidToCpuActivity.adjustOrPutValue(uid, percentage, percentage);
        }
    }

    @Override
    public void setMemoryUsedValue(@NonNull IUniqueThread uniqueThread, long value) {
        assert (false);
    }

    @Override
    public void setProcessMemoryDataAvailable() {
        assert (false);
    }

    @Override
    public void threadExit(@NonNull IUniqueThread uniqueThread) {
        this.threadUpdate(uniqueThread);
    }

    @Override
    public void threadFork(@NonNull IUniqueThread uniqueThread) {
        this.threadUpdate(uniqueThread);
    }

    @Override
    public void threadUpdate(@NonNull IUniqueThread uniqueThread) {
        if (!uniqueThread.isIgnored()) {
            this.insertAndUpdateProcess(uniqueThread);
        }
    }

    protected final void notifyListenersProcessChanged(@NonNull ProcessData processData) {
        this.notifyListenersProcessChanged(Set.of(processData), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyListenersProcessChanged(@NonNull Set<@NonNull ProcessData> processDatas, boolean transactionCommitted) {
        IProcessListener[] listeners;
        if (processDatas.isEmpty()) {
            return;
        }
        LiveProcessDataProvider liveProcessDataProvider = this;
        synchronized (liveProcessDataProvider) {
            listeners = this.processListeners.toArray(new IProcessListener[this.processListeners.size()]);
        }
        IProcessListener[] iProcessListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessListener listener = iProcessListenerArray[n2];
            for (ProcessData processData : processDatas) {
                listener.processChanged(processData);
            }
            if (transactionCommitted) {
                listener.transactionCommitted();
            }
            ++n2;
        }
    }

    private void insertAndUpdateProcess(@NonNull IUniqueThread uniqueThread) {
        if (uniqueThread.isKernel() || uniqueThread.isIdle()) {
            return;
        }
        IUniqueThread process = uniqueThread.getProcessThread();
        if (process == null) {
            return;
        }
        int processUID = process.getUID();
        String processName = process.getNameOrUnknown();
        boolean modified = false;
        ProcessData processData = (ProcessData)this.uidToProcessDataMap.get(processUID);
        if (processData == null) {
            processData = new ProcessData(this.processDataList.size(), processUID, process, processName);
            this.processDataList.add(processData);
            this.uidToProcessDataMap.put(processUID, (Object)processData);
            modified = true;
        } else if (!processName.contentEquals(processData.getProcessName())) {
            processData.setProcessName(processName);
            modified = true;
        }
        if (!processData.hasExited() && this.recalculateExited(process)) {
            processData.setExited(true);
            modified = true;
        }
        if (modified) {
            this.notifyListenersProcessChanged(processData);
        }
    }

    private boolean recalculateExited(@NonNull IUniqueThread process) {
        if (process.getEndTimestamp() == null) {
            return false;
        }
        Set children = this.uniqueThreadTracker.getAllActiveThreads(process);
        return children.isEmpty();
    }
}

