/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.live;

import com.arm.streamline.common.model.counters.GraphRenderingType;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.model.annotation.VisualAnnotationData;
import com.arm.streamline.model.bindata.IBinDataProvider;
import com.arm.streamline.model.capture.ChartConfig;
import com.arm.streamline.model.capture.ChartCoreInformationProvider;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.model.capture.IWildcardSeriesDataProvider;
import com.arm.streamline.model.capture.SeriesConfig;
import com.arm.streamline.model.capture.WildcardSeriesConfig;
import com.arm.streamline.model.live.LiveCaptureDataProvider;
import com.arm.streamline.model.live.LiveSeriesDataProvider;
import com.arm.streamline.model.live.LiveWildcardSeriesDataProvider;
import com.arm.streamline.report.model.pe.ProcessingElementTopology;
import com.arm.utils.NullChecking;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class LiveChartDataProvider
implements IChartDataProvider {
    protected final @NonNull LiveCaptureDataProvider mLiveData;
    private final @NonNull ChartCoreInformationProvider coreInformationProvider;
    private final @NonNull ChartConfig mChartConfig;
    private final @NonNull List<@NonNull ISeriesDataProvider> mSeries = new ArrayList<ISeriesDataProvider>();
    private final @NonNull ProcessingElementReferenceSet processingElementsReferenceSet;
    private @NonNull List<@NonNull IWildcardSeriesDataProvider> wildcardSeries;

    public LiveChartDataProvider(@NonNull LiveCaptureDataProvider liveDataProvider, @NonNull ChartConfig chartConfig, @NonNull ProcessingElementReferenceSet processingElementsReferenceSet) {
        this.mLiveData = liveDataProvider;
        this.mChartConfig = chartConfig;
        this.wildcardSeries = new ArrayList<IWildcardSeriesDataProvider>();
        this.processingElementsReferenceSet = processingElementsReferenceSet;
        this.coreInformationProvider = new ChartCoreInformationProvider(this.mSeries){

            @Override
            public @Nullable ProcessingElementTopology getTopology(@NonNull ProcessingElementReference peReference) {
                return null;
            }

            @Override
            public @Nullable String getVmName(@NonNull ProcessingElementReference peReference) {
                return null;
            }

            @Override
            protected IBinDataProvider getBinDataProvider(@NonNull String source) {
                return LiveChartDataProvider.this.getBinDataProvider(source);
            }

            @Override
            protected int getCoreIndex(@NonNull ProcessingElementReference processingElementReference) {
                return processingElementReference.deviceNumber;
            }

            @Override
            protected @Nullable String getCoreName(@NonNull ProcessingElementReference peReference) {
                return LiveChartDataProvider.this.mLiveData.getAllBinData().getCPUCoreName(peReference);
            }

            @Override
            public boolean hasMultipleVms() {
                return false;
            }
        };
    }

    @Override
    public boolean canCoresBeAveraged() {
        return this.coreInformationProvider.getChannelCount() > 1;
    }

    @Override
    public final @NonNull LiveSeriesDataProvider createSeries(@NonNull SeriesConfig config) {
        LiveSeriesDataProvider series = new LiveSeriesDataProvider(this, config, this.processingElementsReferenceSet);
        this.mSeries.add(series);
        return series;
    }

    @Override
    public final @NonNull LiveSeriesDataProvider createSeries(int index, @NonNull SeriesConfig config) {
        LiveSeriesDataProvider series = new LiveSeriesDataProvider(this, config, this.processingElementsReferenceSet);
        this.mSeries.add(index, series);
        return series;
    }

    @Override
    public final double getAggregateLimit() {
        if (this.isPercentage()) {
            return 1.0;
        }
        return this.getNonPercentageLimit(false);
    }

    @Override
    public long getAlignment() {
        return this.mChartConfig.getAlignment();
    }

    public @NonNull IBinDataProvider getBinDataProvider(@NonNull String source) {
        return (IBinDataProvider)NullChecking.neverNull((Object)this.mLiveData.getAllBinData().getBinData(source));
    }

    @Override
    public final LiveCaptureDataProvider getCaptureDataProvider() {
        return this.mLiveData;
    }

    @Override
    public @NonNull IChartDataProvider.IChartCoreInformationProvider getCoreInformationProvider() {
        return this.coreInformationProvider;
    }

    @Override
    public double getCoreLimit() {
        if (this.isPercentage()) {
            return 1.0;
        }
        return this.getNonPercentageLimit(true);
    }

    @Override
    public int getHeight() {
        return this.mChartConfig.getHeight();
    }

    public double getNonPercentageLimit(boolean perCore) {
        if (this.mSeries.size() == 0) {
            return 0.0;
        }
        double limit = perCore ? this.mSeries.get(0).getCoreLimit() : this.mSeries.get(0).getAggregateLimit();
        boolean seriesLimitsAreLessThanOne = limit <= 1.0;
        int index = 1;
        while (index < this.mSeries.size()) {
            double thisLimit;
            double d = thisLimit = perCore ? this.mSeries.get(index).getCoreLimit() : this.mSeries.get(index).getAggregateLimit();
            if (this.getSeriesComposition() == SeriesComposition.STACKED) {
                limit += thisLimit;
                seriesLimitsAreLessThanOne = seriesLimitsAreLessThanOne && thisLimit <= 1.0;
            } else if (thisLimit > limit) {
                limit = thisLimit;
            }
            ++index;
        }
        if (seriesLimitsAreLessThanOne && this.getSeriesComposition() == SeriesComposition.STACKED && limit > 1.0) {
            limit = 1.0;
        }
        return limit;
    }

    @Override
    public final GraphRenderingType getRenderingType() {
        return this.mChartConfig.getRenderingType();
    }

    @Override
    public final List<ISeriesDataProvider> getSeries() {
        return this.mSeries;
    }

    @Override
    public final SeriesComposition getSeriesComposition() {
        return this.mChartConfig.getSeriesComposition();
    }

    @Override
    public final String getTitle() {
        return this.mLiveData.getVariableReplacer().replace(this.getTitleFormat());
    }

    @Override
    public final @NonNull String getTitleFormat() {
        return this.mChartConfig.getTitle();
    }

    @Override
    public final String getUnits() {
        String units = null;
        for (ISeriesDataProvider series : this.mSeries) {
            String seriesUnits = series.getConfig().getUnits();
            if (units == null) {
                units = seriesUnits;
                continue;
            }
            if (units.equals(seriesUnits)) continue;
            units = "";
        }
        return units;
    }

    @Override
    public final VisualAnnotationData getVisualAnnotationData() {
        return null;
    }

    @Override
    public boolean isAlignmentLinked() {
        return this.isAlignmentSupported() ? this.mChartConfig.isAlignmentLinked() : false;
    }

    @Override
    public boolean isAlignmentSupported() {
        for (ISeriesDataProvider series : this.mSeries) {
            Set<@NonNull String> sources = series.getSources();
            for (String source : sources) {
                if (this.getBinDataProvider(source).getCounterRecord().isAlignmentSupported()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final boolean isAverageCores() {
        return this.mChartConfig.isAverageCores();
    }

    @Override
    public final boolean isAverageSelection() {
        return this.mChartConfig.isAverageSelection();
    }

    @Override
    public boolean isOpen() {
        return this.mChartConfig.isOpen();
    }

    @Override
    public boolean isHeatMapLineEnabled() {
        return this.mChartConfig.isHeatMapLineEnabled();
    }

    @Override
    public final boolean isPercentage() {
        return this.mChartConfig.isPercentage();
    }

    @Override
    public void setAlignment(long alignment) {
        if (this.isAlignmentSupported()) {
            this.mChartConfig.setAlignment(alignment);
            if (this.isAlignmentLinked()) {
                this.mLiveData.updateLinkedAlignment(this);
            }
        }
    }

    @Override
    public void setAlignmentLinked(boolean linked) {
        boolean old;
        if (this.isAlignmentSupported() && (old = this.mChartConfig.isAlignmentLinked()) != linked) {
            this.mChartConfig.setAlignmentLinked(linked);
            if (linked) {
                this.mLiveData.updateLinkedAlignment(this);
            }
        }
    }

    @Override
    public final void setAverageCores(boolean average) {
        if (this.isAverageCores() != average) {
            this.mChartConfig.setAverageCores(average);
            if (this.canCoresBeAveraged()) {
                this.initializeLimits();
            }
        }
    }

    @Override
    public final void setAverageSelection(boolean isAverageSelection) {
        this.mChartConfig.setAverageSelection(isAverageSelection);
    }

    @Override
    public void setHeight(int height) {
        this.mChartConfig.setHeight(height);
    }

    @Override
    public void setOpen(boolean open) {
        this.mChartConfig.setOpen(open);
    }

    @Override
    public final void setPercentage(boolean isPercentage) {
        this.mChartConfig.setPercentage(isPercentage);
    }

    @Override
    public final void setRenderingType(GraphRenderingType renderingType) {
        this.mChartConfig.setRenderingType(renderingType);
    }

    @Override
    public final void setSeriesComposition(SeriesComposition seriesComposition) {
        this.mChartConfig.setSeriesComposition(seriesComposition);
    }

    @Override
    public final void setTitleFormat(String title) {
        this.mChartConfig.setTitle(title);
    }

    private final void initializeLimits() {
        for (ISeriesDataProvider series : this.mSeries) {
            series.initializeLimits();
        }
    }

    @Override
    public void remove(ISeriesDataProvider series) {
        this.mSeries.remove(series);
        this.mLiveData.providersBeingUsedChanged();
    }

    @Override
    public @NonNull ChartConfig getChartConfig() {
        return this.mChartConfig;
    }

    @Override
    public void setHeatMapLineEnabled(boolean heatMapEnabled) {
        this.mChartConfig.setHeatMapLineEnabled(heatMapEnabled);
    }

    @Override
    public @NonNull IWildcardSeriesDataProvider createWildcardSeries(@NonNull WildcardSeriesConfig config) {
        LiveWildcardSeriesDataProvider liveWildcardSeriesDataProvider = new LiveWildcardSeriesDataProvider(config);
        this.wildcardSeries.add(liveWildcardSeriesDataProvider);
        return liveWildcardSeriesDataProvider;
    }

    @Override
    public @NonNull List<@NonNull IWildcardSeriesDataProvider> getWildcardSeries() {
        return this.wildcardSeries;
    }

    @Override
    public void remove(@NonNull IWildcardSeriesDataProvider wildCardSeriesDataProvider) {
        this.wildcardSeries.remove(wildCardSeriesDataProvider);
    }
}

