/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.live;

import com.arm.streamline.analysis.model.ChannelDescriptorUtils;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.model.bindata.IBinDataProvider;
import com.arm.streamline.model.chart.ChartUtility;
import com.arm.streamline.report.shared.Limits;
import com.arm.utils.NullChecking;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TLongHashSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class LiveBinDataProvider
implements IBinDataProvider {
    private final @NonNull CounterRecord mCounterRecord;
    private final @NonNull HashMap<CounterDisplay, TIntObjectHashMap<TLongArrayList>> mValues = new HashMap();
    private boolean mIsEnergy;
    Limits[] mPerCoreLimit;
    Limits[] mAggregateLimit;
    private final @NonNull ProcessingElementReference @NonNull [] mChannelDescriptors;

    public LiveBinDataProvider(@NonNull CounterRecord cr, @NonNull ProcessingElementReferenceSet processingElementsReferenceSet) {
        this.mCounterRecord = cr;
        this.mChannelDescriptors = ChannelDescriptorUtils.makeChannelDescriptors((ProcessingElementReferenceSet)processingElementsReferenceSet, (CounterRecord)cr);
        int cores = cr.getCores();
        if (cores > 1 && !cr.isPerCPU()) {
            StreamlinePlugin.warning("System wide counter detected with > 1 core");
        }
        assert (cores <= 0 && this.mChannelDescriptors.length == 1 || cores == this.mChannelDescriptors.length) : String.format("Invalid core/channel combination: %d vs %d (%s) - %s", cores, this.mChannelDescriptors.length, Arrays.toString(this.mChannelDescriptors), cr);
        List<CounterDisplay> displayList = ChartUtility.getDisplayOptions(cr.getCounterClass());
        for (CounterDisplay option : displayList) {
            if (option.isHertz()) continue;
            TIntObjectHashMap values = new TIntObjectHashMap();
            this.mValues.put(option, (TIntObjectHashMap<TLongArrayList>)values);
            int i = 0;
            while (i < this.mChannelDescriptors.length) {
                assert (this.mChannelDescriptors[i].vmUID == 0L);
                assert (this.mChannelDescriptors[i].deviceNumber == i);
                values.put(i, (Object)new TLongArrayList());
                ++i;
            }
            this.mPerCoreLimit = new Limits[CounterDisplay.values().length];
            this.mAggregateLimit = new Limits[CounterDisplay.values().length];
            for (CounterDisplay display : CounterDisplay.analysisDisplayOptions()) {
                this.mPerCoreLimit[display.ordinal()] = new Limits();
                this.mAggregateLimit[display.ordinal()] = new Limits();
            }
        }
    }

    public void addValue(CounterDisplay display, int core, long value) {
        @Nullable TIntObjectHashMap<TLongArrayList> displayValues = this.mValues.get(display);
        if (displayValues == null) {
            return;
        }
        TLongArrayList coreValues = (TLongArrayList)displayValues.get(core);
        if (coreValues == null) {
            return;
        }
        coreValues.add(value);
        int binIndex = coreValues.size() - 1;
        long sum = 0L;
        if (display.isAccumulate()) {
            int size = displayValues.size();
            int c = 0;
            while (c < size) {
                sum += this.getValue(display, binIndex, c);
                ++c;
            }
        } else {
            sum = value;
        }
        this.mPerCoreLimit[display.ordinal()].updateLimits(value, (long)binIndex);
        this.mAggregateLimit[display.ordinal()].updateLimits(sum, (long)binIndex);
    }

    public void addValues(int core, long[] values) {
        Set<CounterDisplay> set = this.mValues.keySet();
        for (CounterDisplay display : set) {
            long[] lArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                long value = lArray[n2];
                this.addValue(display, core, value);
                ++n2;
            }
        }
    }

    public int getBinCount() {
        int smallest = Integer.MAX_VALUE;
        for (TIntObjectHashMap<TLongArrayList> displayValues : this.mValues.values()) {
            int core = 0;
            while (core < this.getCounterRecord().getCores()) {
                int size = ((TLongArrayList)displayValues.get(core)).size();
                if (size < smallest) {
                    smallest = size;
                }
                ++core;
            }
        }
        return smallest;
    }

    @Override
    public CounterRecord getCounterRecord() {
        return this.mCounterRecord;
    }

    @Override
    public long[] getLimits() {
        TLongHashSet limitSet = new TLongHashSet();
        for (CounterDisplay display : CounterDisplay.analysisDisplayOptions()) {
            int core = 0;
            while (core < this.getCounterRecord().getCores()) {
                limitSet.addAll(this.mPerCoreLimit[display.ordinal()].getIndices());
                ++core;
            }
            limitSet.addAll(this.mAggregateLimit[display.ordinal()].getIndices());
        }
        return (long[])NullChecking.neverNull((Object)limitSet.toArray());
    }

    @Override
    public int getRescale(@NonNull ZoomLevel desiredZoomLevel) {
        return 1;
    }

    @Override
    public long getValue(@NonNull CounterDisplay display, int scale, long bin, int channelNumber, @Nullable TIntSet tids) {
        return this.getValue(display, bin, channelNumber);
    }

    private long getValue(CounterDisplay display, long bin, int core) {
        TLongArrayList list;
        TIntObjectHashMap<TLongArrayList> values = this.mValues.get(display);
        if (values == null) {
            if (display.isHertz()) {
                values = this.mValues.get(CounterDisplay.ACCUMULATE);
            }
            if (values == null) {
                return 0L;
            }
        }
        if ((list = (TLongArrayList)values.get(core)) == null || bin >= (long)list.size()) {
            return 0L;
        }
        return list.get((int)bin);
    }

    public boolean isEnergy() {
        return this.mIsEnergy;
    }

    @Override
    public boolean isFilterable() {
        return false;
    }

    @Override
    public void prepareRange(@NonNull ZoomLevel zoomLevel, long start, long end) {
    }

    @Override
    public void run() {
    }

    public void setEnergy(boolean isEnergy) {
        this.mCounterRecord.setAlignmentSupported(true);
        this.mIsEnergy = isEnergy;
    }

    @Override
    public @NonNull ProcessingElementReference @NonNull [] getChannelDescriptors() {
        return this.mChannelDescriptors;
    }

    @Override
    public int mapChannelNumber(@NonNull ProcessingElementReference peReference) {
        assert (peReference.vmUID == 0L);
        return peReference.deviceNumber;
    }
}

