/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.icounters.incident;

import com.arm.streamline.editortabs.function.FunctionMessages;
import com.arm.streamline.editortabs.report.ColumnUtils;
import com.arm.streamline.model.icounters.incident.IIncidentColumnProvider;
import com.arm.streamline.report.model.icounters.IInstructionCounterColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctionView;
import com.arm.streamline.report.model.icounters.IInstructionCounterPercentAndValueColumn;
import com.arm.streamline.report.model.icounters.PercentAndValue;
import com.arm.streamline.report.model.icounters.impl.InstructionCounterPercentAndValueColumn;
import java.text.MessageFormat;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class IncidentFunctionInstructionCounterColumns {
    public final @NonNull IInstructionCounterPercentAndValueColumn<IInstructionCounterFunctionView> SELF_VALUE_PERCENT;
    public final @NonNull IInstructionCounterPercentAndValueColumn<IInstructionCounterFunctionView> TOTAL_VALUE_PERCENT;

    public IncidentFunctionInstructionCounterColumns(final @NonNull IIncidentColumnProvider provider, final int eventId, final int dataPointId, @NonNull String title, @NonNull String description, final @NonNull String unit, @NonNull String name, @Nullable Integer colourRGB) {
        @NonNull String selfValuePercentTitle = MessageFormat.format(FunctionMessages.FORMAT_SELF_VALUE_PERCENT_TITLE, title);
        @NonNull String selfValuePercentDescription = MessageFormat.format(FunctionMessages.FORMAT_SELF_VALUE_PERCENT_DESCRIPTION, title, description);
        @NonNull String selfPercentTitle = MessageFormat.format(FunctionMessages.FORMAT_SELF_PERCENT_TITLE, title);
        @NonNull String selfPercentDescription = MessageFormat.format(FunctionMessages.FORMAT_SELF_PERCENT_DESCRIPTION, title, description);
        @NonNull String selfValueTitle = MessageFormat.format(FunctionMessages.FORMAT_SELF_VALUE_TITLE, title);
        @NonNull String selfValueDescription = MessageFormat.format(FunctionMessages.FORMAT_SELF_VALUE_DESCRIPTION, title, description);
        @NonNull String totalValuePercentTitle = MessageFormat.format(FunctionMessages.FORMAT_CUMULATIVE_VALUE_PERCENT_TITLE, title);
        @NonNull String totalValuePercentDescription = MessageFormat.format(FunctionMessages.FORMAT_CUMULATIVE_VALUE_PERCENT_DESCRIPTION, title, description);
        @NonNull String totalPercentTitle = MessageFormat.format(FunctionMessages.FORMAT_CUMULATIVE_PERCENT_TITLE, title);
        @NonNull String totalPercentDescription = MessageFormat.format(FunctionMessages.FORMAT_CUMULATIVE_PERCENT_DESCRIPTION, title, description);
        @NonNull String totalValueTitle = MessageFormat.format(FunctionMessages.FORMAT_CUMULATIVE_VALUE_TITLE, title);
        @NonNull String totalValueDescription = MessageFormat.format(FunctionMessages.FORMAT_CUMULATIVE_VALUE_DESCRIPTION, title, description);
        this.SELF_VALUE_PERCENT = new InstructionCounterPercentAndValueColumn<IInstructionCounterFunctionView>(provider.getInstructionCounterSource(), selfValuePercentTitle, selfValuePercentDescription, selfPercentTitle, selfPercentDescription, selfValueTitle, selfValueDescription){

            public @Nullable IInstructionCounterColumn<IInstructionCounterFunctionView> getParentColumn() {
                return null;
            }

            protected @Nullable PercentAndValue calculatePercentAndValue(@NonNull IInstructionCounterFunctionView functionView) {
                long total = provider.getTotal(eventId, dataPointId);
                if (total <= 0L) {
                    return null;
                }
                long value = functionView.getCounterSet().getSelfCounterValue(eventId, dataPointId);
                double percent = (double)value * 100.0 / (double)total;
                return new PercentAndValue(value, percent);
            }

            protected long getMaxPossibleDisplayValue() {
                return provider.getTotal(eventId, dataPointId);
            }

            protected @NonNull String makeValueTooltip(@NonNull IInstructionCounterFunctionView mappedValue, @NonNull PercentAndValue percentAndValue) {
                return ColumnUtils.percentAmountTip(percentAndValue.value, percentAndValue.percent, unit);
            }
        };
        this.TOTAL_VALUE_PERCENT = new InstructionCounterPercentAndValueColumn<IInstructionCounterFunctionView>(provider.getInstructionCounterSource(), totalValuePercentTitle, totalValuePercentDescription, totalPercentTitle, totalPercentDescription, totalValueTitle, totalValueDescription){

            public @Nullable IInstructionCounterColumn<IInstructionCounterFunctionView> getParentColumn() {
                return null;
            }

            protected @Nullable PercentAndValue calculatePercentAndValue(@NonNull IInstructionCounterFunctionView functionView) {
                long total = provider.getTotal(eventId, dataPointId);
                if (total <= 0L) {
                    return null;
                }
                long value = functionView.getCounterSet().getTotalCounterValue(eventId, dataPointId);
                double percent = (double)value * 100.0 / (double)total;
                return new PercentAndValue(value, percent);
            }

            protected long getMaxPossibleDisplayValue() {
                return provider.getTotal(eventId, dataPointId);
            }

            protected @NonNull String makeValueTooltip(@NonNull IInstructionCounterFunctionView mappedValue, @NonNull PercentAndValue percentAndValue) {
                return ColumnUtils.percentAmountTip(percentAndValue.value, percentAndValue.percent, unit);
            }
        };
    }
}

