/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.icounters.incident;

import com.arm.streamline.editortabs.callpath.CallPathMessages;
import com.arm.streamline.editortabs.report.ColumnUtils;
import com.arm.streamline.model.icounters.incident.IIncidentColumnProvider;
import com.arm.streamline.report.model.ICallPathFunction;
import com.arm.streamline.report.model.icounters.IInstructionCounterColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterPercentAndValueColumn;
import com.arm.streamline.report.model.icounters.PercentAndValue;
import com.arm.streamline.report.model.icounters.impl.InstructionCounterPercentAndValueColumn;
import java.text.MessageFormat;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class IncidentCallPathFunctionInstructionCounterColumns {
    public final @NonNull IInstructionCounterPercentAndValueColumn<ICallPathFunction> SELF_VALUE_PERCENT;

    public IncidentCallPathFunctionInstructionCounterColumns(final @NonNull IIncidentColumnProvider provider, final int eventId, final int dataPointId, @NonNull String title, @NonNull String description, final @NonNull String unit, @NonNull String name, @Nullable Integer colourRGB) {
        @NonNull String selfValuePercentTitle = MessageFormat.format(CallPathMessages.FORMAT_CPF_VALUE_PERCENT_TITLE, title);
        @NonNull String selfValuePercentDescription = MessageFormat.format(CallPathMessages.FORMAT_CPF_VALUE_PERCENT_DESCRIPTION, title, description);
        @NonNull String selfPercentTitle = MessageFormat.format(CallPathMessages.FORMAT_CPF_PERCENT_TITLE, title);
        @NonNull String selfPercentDescription = MessageFormat.format(CallPathMessages.FORMAT_CPF_PERCENT_DESCRIPTION, title, description);
        @NonNull String selfValueTitle = MessageFormat.format(CallPathMessages.FORMAT_CPF_VALUE_TITLE, title);
        @NonNull String selfValueDescription = MessageFormat.format(CallPathMessages.FORMAT_CPF_VALUE_DESCRIPTION, title, description);
        this.SELF_VALUE_PERCENT = new InstructionCounterPercentAndValueColumn<ICallPathFunction>(provider.getInstructionCounterSource(), selfValuePercentTitle, selfValuePercentDescription, selfPercentTitle, selfPercentDescription, selfValueTitle, selfValueDescription){

            public @Nullable IInstructionCounterColumn<ICallPathFunction> getParentColumn() {
                return null;
            }

            protected @Nullable PercentAndValue calculatePercentAndValue(@NonNull ICallPathFunction cpf) {
                long total = cpf.getCallPathTotalCounterValue(eventId, dataPointId);
                if (total <= 0L) {
                    return null;
                }
                long value = cpf.getCounterValue(eventId, dataPointId);
                double percent = (double)value * 100.0 / (double)total;
                return new PercentAndValue(value, percent);
            }

            protected long getMaxPossibleDisplayValue() {
                return provider.getTotal(eventId, dataPointId);
            }

            protected @NonNull String makeValueTooltip(@NonNull ICallPathFunction mappedValue, @NonNull PercentAndValue percentAndValue) {
                return ColumnUtils.percentAmountTip(percentAndValue.value, percentAndValue.percent, unit);
            }
        };
    }
}

