/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.icounters;

import com.arm.streamline.analysis.model.metrics.IMetricProcessor;
import com.arm.streamline.analysis.model.metrics.IMetricValuesGetter;
import com.arm.streamline.analysis.model.metrics.MetricConstantDefaults;
import com.arm.streamline.analysis.model.metrics.MetricConstants;
import com.arm.streamline.analysis.model.metrics.MetricProcessorProperties;
import com.arm.streamline.analysis.model.metrics.MetricProcessors;
import com.arm.streamline.common.utility.io.IProgressTracker;
import com.arm.streamline.model.icounters.IInstructionCounterDataFileLoader;
import com.arm.streamline.model.icounters.InstructionCounter;
import com.arm.streamline.model.icounters.InstructionCounterEvent;
import com.arm.streamline.model.icounters.incident.IIncidentColumnProvider;
import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.ICallPathFunction;
import com.arm.streamline.report.model.SamplesData;
import com.arm.streamline.report.model.icounters.IInstructionCounter;
import com.arm.streamline.report.model.icounters.IInstructionCounterCallPaths;
import com.arm.streamline.report.model.icounters.IInstructionCounterColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterColumnDisplayTypeVisitor;
import com.arm.streamline.report.model.icounters.IInstructionCounterDecimalColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctionView;
import com.arm.streamline.report.model.icounters.IInstructionCounterPercentColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterSource;
import com.arm.streamline.report.model.icounters.InstructionCounterConstants;
import com.arm.streamline.report.model.icounters.callpathsandfunctions.ICallPathAndFunctionCounterViews;
import com.arm.streamline.report.model.icounters.impl.RecomputeRange;
import com.arm.streamline.report.model.icounters.instructionandsource.IInstructionsAndSourcefileLineCounterViews;
import com.arm.streamline.report.model.icounters.io.IIncidentCounterDataSource;
import com.arm.utils.collections.Pair;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class MetricInstructionCounterEvent
extends InstructionCounterEvent
implements IIncidentColumnProvider {
    private static final double LIMIT_MPKI = 1000.0;
    private static final double LIMIT_NUMBER = Double.MAX_VALUE;
    private static final double LIMIT_PERCENT = 100.0;
    private final @NonNull List<@NonNull IInstructionCounter> columns = new ArrayList<IInstructionCounter>();
    private final @NonNull IIncidentCounterDataSource @NonNull [] dataSourcesByIndex;
    private final @NonNull MetricProcessorProperties metric;

    private static @Nullable Double sanitize(@Nullable Double n) {
        if (n == null) {
            return null;
        }
        if (n.isNaN() || n < 0.0 || n.isInfinite()) {
            return null;
        }
        return n;
    }

    private static double sanitizeToMaxPossible(@Nullable Double n, double limit) {
        if (n == null) {
            return 0.0;
        }
        if (n.isNaN() || n < 0.0 || n.isInfinite()) {
            return 0.0;
        }
        return Math.min(n, limit);
    }

    private static @Nullable Double sanitizeToNumber(@Nullable Double n, double limit) {
        if (n == null) {
            return null;
        }
        if (n.isNaN() || n < 0.0 || n.isInfinite()) {
            return null;
        }
        return Math.min(n, limit);
    }

    public MetricInstructionCounterEvent(@NonNull IInstructionCounterDataFileLoader dataFileLoader, @NonNull IInstructionCounterSource instructionCounterSource, @NonNull IProgressTracker tracker, @NonNull IInstructionsAndSourcefileLineCounterViews instructionAndSourceLineCounterViews, @NonNull IInstructionCounterCallPaths profileCallPathsFile, @NonNull ICallPathAndFunctionCounterViews callPathAndFunctionCounterViews, @NonNull File eventDir, int eventId, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull InstructionCounterMetadataXml.MetricInstructionCounterMetadata metadata, int @NonNull [] availableDataPoints) throws IOException, InterruptedException {
        super(instructionCounterSource, eventId, instructionAndSourceLineCounterViews, profileCallPathsFile, callPathAndFunctionCounterViews);
        Pair metricAndDefaults = (Pair)MetricProcessors.METRIC_PROCESSORS.get(metadata.getID());
        if (metricAndDefaults == null) {
            throw new AssertionError((Object)("Missing metric for " + metadata.getID()));
        }
        MetricProcessorProperties metric = (MetricProcessorProperties)metricAndDefaults.first;
        MetricConstantDefaults constantDefaults = (MetricConstantDefaults)metricAndDefaults.second;
        IMetricProcessor processor = metric.factory.make(constantDefaults, availableDataPoints);
        if (processor == null) {
            throw new AssertionError((Object)("Missing metric processor for " + metadata.getID()));
        }
        this.metric = metric;
        MetricConstants constants = new MetricConstants(null);
        switch (metric.format) {
            case cpi: 
            case ipc: 
            case number: 
            case cycles: {
                this.columns.add(new InstructionCounter((IInstructionCounterColumn<ICallPath>)new Column<ICallPath>(instructionCounterSource, metric, constants, processor, Double.MAX_VALUE, true, false, this::getCallPathTotal, this::getCallPathTotalMax), (IInstructionCounterColumn<IInstructionCounterFunctionView>)new Column<IInstructionCounterFunctionView>(instructionCounterSource, metric, constants, processor, Double.MAX_VALUE, true, true, this::getFunctionTotal, this::getFunctionTotalMax), null, null));
                this.columns.add(new InstructionCounter((IInstructionCounterColumn<ICallPath>)new Column<ICallPath>(instructionCounterSource, metric, constants, processor, Double.MAX_VALUE, false, true, this::getCallPathSelf, this::getCallPathSelfMax), (IInstructionCounterColumn<IInstructionCounterFunctionView>)new Column<IInstructionCounterFunctionView>(instructionCounterSource, metric, constants, processor, Double.MAX_VALUE, false, false, this::getFunctionSelf, this::getFunctionSelfMax), (IInstructionCounterColumn<ICallPathFunction>)new Column<ICallPathFunction>(instructionCounterSource, metric, constants, processor, Double.MAX_VALUE, false, false, this::getCallPathFunctionSelf, this::getCallPathFunctionSelfMax), null));
                break;
            }
            case percent: 
            case ratio: 
            case percent_cycles: {
                this.columns.add(new InstructionCounter((IInstructionCounterColumn<ICallPath>)new ColumnPercent<ICallPath>(instructionCounterSource, metric, constants, processor, 100.0, true, false, this::getCallPathTotal), (IInstructionCounterColumn<IInstructionCounterFunctionView>)new ColumnPercent<IInstructionCounterFunctionView>(instructionCounterSource, metric, constants, processor, 100.0, true, true, this::getFunctionTotal), null, null));
                this.columns.add(new InstructionCounter((IInstructionCounterColumn<ICallPath>)new ColumnPercent<ICallPath>(instructionCounterSource, metric, constants, processor, 100.0, false, true, this::getCallPathSelf), (IInstructionCounterColumn<IInstructionCounterFunctionView>)new ColumnPercent<IInstructionCounterFunctionView>(instructionCounterSource, metric, constants, processor, 100.0, false, false, this::getFunctionSelf), (IInstructionCounterColumn<ICallPathFunction>)new ColumnPercent<ICallPathFunction>(instructionCounterSource, metric, constants, processor, 100.0, false, false, this::getCallPathFunctionSelf), null));
                break;
            }
            case mpki: {
                this.columns.add(new InstructionCounter((IInstructionCounterColumn<ICallPath>)new ColumnPercent<ICallPath>(instructionCounterSource, metric, constants, processor, 1000.0, true, false, this::getCallPathTotal), (IInstructionCounterColumn<IInstructionCounterFunctionView>)new ColumnPercent<IInstructionCounterFunctionView>(instructionCounterSource, metric, constants, processor, 1000.0, true, true, this::getFunctionTotal), null, null));
                this.columns.add(new InstructionCounter((IInstructionCounterColumn<ICallPath>)new ColumnPercent<ICallPath>(instructionCounterSource, metric, constants, processor, 1000.0, false, true, this::getCallPathSelf), (IInstructionCounterColumn<IInstructionCounterFunctionView>)new ColumnPercent<IInstructionCounterFunctionView>(instructionCounterSource, metric, constants, processor, 1000.0, false, false, this::getFunctionSelf), (IInstructionCounterColumn<ICallPathFunction>)new ColumnPercent<ICallPathFunction>(instructionCounterSource, metric, constants, processor, 1000.0, false, false, this::getCallPathFunctionSelf), null));
                break;
            }
            default: {
                throw new AssertionError(metric.format);
            }
        }
        this.dataSourcesByIndex = new IIncidentCounterDataSource[availableDataPoints.length];
        int dataPointIndex = 0;
        while (dataPointIndex < availableDataPoints.length) {
            IIncidentCounterDataSource loader;
            int dataPointId = availableDataPoints[dataPointIndex];
            File dataPointDir = InstructionCounterConstants.getDataPointPath((File)eventDir, (int)dataPointId);
            MetricInstructionCounterEvent.loadInitialValues(dataFileLoader, tracker, dataPointDir, eventId, dataPointIndex, callPathAndFunctionCounterViews, instructionAndSourceLineCounterViews);
            this.dataSourcesByIndex[dataPointIndex] = loader = dataFileLoader.createIncidentCounterDataSource(dataPointDir);
            ++dataPointIndex;
        }
    }

    @Override
    public @NonNull List<@NonNull IInstructionCounter> getInstructionCounters() {
        return this.columns;
    }

    @Override
    public @NonNull IInstructionCounterSource getInstructionCounterSource() {
        return this.instructionCounterSource;
    }

    public @NonNull MetricProcessorProperties getMetric() {
        return this.metric;
    }

    @Override
    public @NonNull String getTitle() {
        return "Top-Down";
    }

    @Override
    public long getTotal(int eventId, int dataPointIndex) {
        return this.recomputeRangeProperties.getCallPathsAndFunctions().getTotal(eventId, dataPointIndex);
    }

    @Override
    public boolean isSamplesCounter() {
        return false;
    }

    @Override
    public @NonNull List<@NonNull SamplesData> recomputeCSMSamplesData(long fromUs, long toUs) throws Exception {
        assert (false);
        return Collections.emptyList();
    }

    @Override
    public void recomputeSelectedCounterRange(long fromUs, long toUs) throws Exception {
        int dataPointIndex = 0;
        while (dataPointIndex < this.dataSourcesByIndex.length) {
            new RecomputeRange(this.recomputeRangeProperties, this.dataSourcesByIndex[dataPointIndex], this.eventId, dataPointIndex, fromUs, toUs).call();
            ++dataPointIndex;
        }
    }

    private @Nullable Double getCallPathFunctionSelf(@NonNull ICallPathFunction data, int dataPointIndex) {
        return data.getCounterValue(this.eventId, dataPointIndex);
    }

    private @Nullable Double getCallPathFunctionSelfMax(int dataPointIndex) {
        return Math.max(this.recomputeRangeProperties.getCallPathsAndFunctions().getMaximumCallPathSelfValue(this.eventId, dataPointIndex), this.recomputeRangeProperties.getCallPathsAndFunctions().getMaximumFunctionSelfValue(this.eventId, dataPointIndex));
    }

    private @Nullable Double getCallPathSelf(@NonNull ICallPath data, int dataPointIndex) {
        return data.getCounters().getSelfCounterValue(this.eventId, dataPointIndex);
    }

    private @Nullable Double getCallPathSelfMax(int dataPointIndex) {
        return this.recomputeRangeProperties.getCallPathsAndFunctions().getMaximumCallPathSelfValue(this.eventId, dataPointIndex);
    }

    private @Nullable Double getCallPathTotal(@NonNull ICallPath data, int dataPointIndex) {
        return data.getCounters().getTotalCounterValue(this.eventId, dataPointIndex);
    }

    private @Nullable Double getCallPathTotalMax(int dataPointIndex) {
        return this.recomputeRangeProperties.getCallPathsAndFunctions().getTotal(this.eventId, dataPointIndex);
    }

    private @Nullable Double getFunctionSelf(@NonNull IInstructionCounterFunctionView data, int dataPointIndex) {
        return data.getCounterSet().getSelfCounterValue(this.eventId, dataPointIndex);
    }

    private @Nullable Double getFunctionSelfMax(int dataPointIndex) {
        return this.recomputeRangeProperties.getCallPathsAndFunctions().getMaximumFunctionSelfValue(this.eventId, dataPointIndex);
    }

    private @Nullable Double getFunctionTotal(@NonNull IInstructionCounterFunctionView data, int dataPointIndex) {
        return data.getCounterSet().getTotalCounterValue(this.eventId, dataPointIndex);
    }

    private @Nullable Double getFunctionTotalMax(int dataPointIndex) {
        return this.recomputeRangeProperties.getCallPathsAndFunctions().getMaximumFunctionSelfValue(this.eventId, dataPointIndex);
    }

    private static final class Column<T>
    implements IInstructionCounterDecimalColumn<T> {
        private final @NonNull MetricConstants constants;
        private final boolean cumulative;
        private final boolean hiddenByDefault;
        private final @NonNull IInstructionCounterSource instructionCounterSource;
        private final double limit;
        private final @NonNull IMetricValuesGetter maxGetter;
        private final @NonNull IMetricProcessor processor;
        private final @NonNull MetricProcessorProperties properties;
        private final @NonNull ITopDownFieldGetter<T> valueGetter;

        public Column(@NonNull IInstructionCounterSource instructionCounterSource, @NonNull MetricProcessorProperties properties, @NonNull MetricConstants constants, @NonNull IMetricProcessor processor, double limit, boolean cumulative, boolean hiddenByDefault, @NonNull ITopDownFieldGetter<T> valueGetter, @NonNull IMetricValuesGetter maxGetter) {
            this.instructionCounterSource = instructionCounterSource;
            this.properties = properties;
            this.constants = constants;
            this.processor = processor;
            this.cumulative = cumulative;
            this.hiddenByDefault = hiddenByDefault;
            this.valueGetter = (d, i) -> i >= 0 ? valueGetter.get(d, i) : null;
            this.limit = limit;
            this.maxGetter = i -> MetricInstructionCounterEvent.sanitize(maxGetter.get(i));
        }

        public <U, R, E extends Throwable> R acceptDisplayTypeVisitor(@NonNull IInstructionCounterColumnDisplayTypeVisitor<T, U, R, E> visitor, U data) throws E {
            return (R)visitor.displayAsDecimal(data, (IInstructionCounterDecimalColumn)this);
        }

        public @Nullable Comparator<@NonNull T> getComparator() {
            return new ColumnComparator<T>(this.processor, this.valueGetter, this.constants, this.limit);
        }

        public @NonNull IInstructionCounterSource getInstructionCounterSource() {
            return this.instructionCounterSource;
        }

        public double getMaxPossibleDisplayValue() {
            return MetricInstructionCounterEvent.sanitizeToMaxPossible(this.processor.process(this.maxGetter, this.constants), this.limit);
        }

        public @Nullable IInstructionCounterColumn<T> getParentColumn() {
            return null;
        }

        public @NonNull String getTitle() {
            return String.format("%s (%s)", this.properties.title, this.cumulative ? "Cumulative" : "Self");
        }

        public @NonNull String getTitleTooltip() {
            return this.properties.description;
        }

        public @NonNull String getValueTooltip(@NonNull T value) {
            return this.properties.description;
        }

        public boolean isVisibleByDefault() {
            return !this.hiddenByDefault;
        }

        public @Nullable Double mapToNumber(@NonNull T data) {
            return MetricInstructionCounterEvent.sanitizeToNumber(this.processor.process(i -> MetricInstructionCounterEvent.sanitize(this.valueGetter.get(data, i)), this.constants), this.limit);
        }
    }

    @SuppressFBWarnings(value={"RC_REF_COMPARISON"})
    private static final class ColumnComparator<T>
    implements Comparator<T> {
        private final @NonNull MetricConstants constants;
        private final double limit;
        private final @NonNull IMetricProcessor processor;
        private final @NonNull ITopDownFieldGetter<T> valueGetter;

        public ColumnComparator(@NonNull IMetricProcessor processor, @NonNull ITopDownFieldGetter<T> valueGetter, @NonNull MetricConstants constants, double limit) {
            this.processor = processor;
            this.valueGetter = valueGetter;
            this.constants = constants;
            this.limit = limit;
        }

        @Override
        public int compare(@NonNull T a, @NonNull T b) {
            Double bValue;
            Double aValue = MetricInstructionCounterEvent.sanitizeToNumber(this.processor.process(i -> MetricInstructionCounterEvent.sanitize(this.valueGetter.get(a, i)), this.constants), this.limit);
            if (aValue == (bValue = MetricInstructionCounterEvent.sanitizeToNumber(this.processor.process(i -> MetricInstructionCounterEvent.sanitize(this.valueGetter.get(b, i)), this.constants), this.limit))) {
                return 0;
            }
            if (aValue == null) {
                return -1;
            }
            if (bValue == null) {
                return 1;
            }
            return aValue.compareTo(bValue);
        }
    }

    private static final class ColumnPercent<T>
    implements IInstructionCounterPercentColumn<T> {
        private final @NonNull MetricConstants constants;
        private final boolean cumulative;
        private final boolean hiddenByDefault;
        private final @NonNull IInstructionCounterSource instructionCounterSource;
        private final double limit;
        private final @NonNull IMetricProcessor processor;
        private final @NonNull MetricProcessorProperties properties;
        private final @NonNull ITopDownFieldGetter<T> valueGetter;

        public ColumnPercent(@NonNull IInstructionCounterSource instructionCounterSource, @NonNull MetricProcessorProperties properties, @NonNull MetricConstants constants, @NonNull IMetricProcessor processor, double limit, boolean cumulative, boolean hiddenByDefault, @NonNull ITopDownFieldGetter<T> valueGetter) {
            this.instructionCounterSource = instructionCounterSource;
            this.properties = properties;
            this.constants = constants;
            this.processor = processor;
            this.cumulative = cumulative;
            this.hiddenByDefault = hiddenByDefault;
            this.valueGetter = (d, i) -> i >= 0 ? valueGetter.get(d, i) : null;
            this.limit = limit;
        }

        public <U, R, E extends Throwable> R acceptDisplayTypeVisitor(@NonNull IInstructionCounterColumnDisplayTypeVisitor<T, U, R, E> visitor, U data) throws E {
            return (R)visitor.displayAsPercent(data, (IInstructionCounterPercentColumn)this);
        }

        public @Nullable Comparator<@NonNull T> getComparator() {
            return new ColumnComparator<T>(this.processor, this.valueGetter, this.constants, this.limit);
        }

        public @NonNull IInstructionCounterSource getInstructionCounterSource() {
            return this.instructionCounterSource;
        }

        public @Nullable IInstructionCounterColumn<T> getParentColumn() {
            return null;
        }

        public @NonNull String getTitle() {
            return String.format("%s (%s)", this.properties.title, this.cumulative ? "Cumulative" : "Self");
        }

        public @NonNull String getTitleTooltip() {
            return this.properties.description;
        }

        public @NonNull String getValueTooltip(@NonNull T value) {
            return this.properties.description;
        }

        public boolean isVisibleByDefault() {
            return !this.hiddenByDefault;
        }

        public @Nullable Double mapToPercent(@NonNull T data) {
            Double n = MetricInstructionCounterEvent.sanitizeToNumber(this.processor.process(i -> MetricInstructionCounterEvent.sanitize(this.valueGetter.get(data, i)), this.constants), this.limit);
            if (n == null) {
                return null;
            }
            return n * 100.0 / this.limit;
        }
    }

    @FunctionalInterface
    private static interface ITopDownFieldGetter<T> {
        public @Nullable Double get(@NonNull T var1, int var2);
    }
}

