/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.icounters;

import com.arm.streamline.analysis.database.api.profiling.BacktraceSource;
import com.arm.streamline.common.model.icounters.InstructionCounterSourceMetadata;
import com.arm.streamline.common.utility.io.IProgressTracker;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.callpath.CallPathMessages;
import com.arm.streamline.editortabs.code.CodeMessages;
import com.arm.streamline.editortabs.function.FunctionMessages;
import com.arm.streamline.model.icounters.IInstructionCounterDataFileLoader;
import com.arm.streamline.model.icounters.IncidentInstructionCounterEvent;
import com.arm.streamline.model.icounters.InstructionCounterEvent;
import com.arm.streamline.model.icounters.InstructionCountersModel;
import com.arm.streamline.model.icounters.MetricInstructionCounterEvent;
import com.arm.streamline.report.model.CallPathFunction;
import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.ICallPathFunction;
import com.arm.streamline.report.model.IFunction;
import com.arm.streamline.report.model.IRawInstructionsFile;
import com.arm.streamline.report.model.IVirtualMachineBasicProperties;
import com.arm.streamline.report.model.SamplesData;
import com.arm.streamline.report.model.icounters.IInstructionCounter;
import com.arm.streamline.report.model.icounters.IInstructionCounterCallPaths;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctionView;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctionViews;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctions;
import com.arm.streamline.report.model.icounters.IInstructionCounterInstructionViews;
import com.arm.streamline.report.model.icounters.IInstructionCounterModel;
import com.arm.streamline.report.model.icounters.IInstructionCounterSource;
import com.arm.streamline.report.model.icounters.IInstructionCounterSourcefileView;
import com.arm.streamline.report.model.icounters.IInstructionCounterSourcefileViews;
import com.arm.streamline.report.model.icounters.ISourcefileLineMap;
import com.arm.streamline.report.model.icounters.InstructionCounterConstants;
import com.arm.streamline.report.model.icounters.callpathsandfunctions.CallPath;
import com.arm.streamline.report.model.icounters.callpathsandfunctions.CallPathAndFunctionCounterViews;
import com.arm.streamline.report.model.icounters.callpathsandfunctions.ICallPathAndFunctionCounterViews;
import com.arm.streamline.report.model.icounters.callpathsandfunctions.InstructionCounterCallPaths;
import com.arm.streamline.report.model.icounters.callpathsandfunctions.InstructionCounterFunctions;
import com.arm.streamline.report.model.icounters.instructionandsource.IInstructionsAndSourcefileLineCounterViews;
import com.arm.streamline.report.model.icounters.instructionandsource.InstructionsAndSourcefileLineCounterViews;
import com.arm.streamline.report.model.icounters.io.ICallPathsReader;
import com.arm.streamline.report.model.icounters.io.structure.CallPathsReader;
import com.arm.streamline.report.shared.icounter.InstructionCounterMetadataXml;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TLongObjectMap;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class InstructionCounterSource
implements IInstructionCounterSource,
Closeable {
    private final @NonNull ICallPathAndFunctionCounterViews callPathAndFunctionCounterViews;
    private final @NonNull List<@NonNull InstructionCounterEvent> counters;
    private final @NonNull InstructionsAndSourcefileLineCounterViews instructionAndSourceLineCounterViews;
    private final int largestFunctionCallChainCount;
    private final @NonNull InstructionCounterSourceMetadata metadata;
    private final @NonNull IInstructionCounterModel model;
    private final int @NonNull [] numDataPointsByEvent;
    private final @NonNull InstructionCounterCallPaths profileCallPathsFile;
    private final @Nullable InstructionCounterEvent samplesCounter;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public InstructionCounterSource(@NonNull InstructionCountersModel model, @NonNull IProgressTracker tracker, @NonNull TLongObjectMap<? extends IVirtualMachineBasicProperties> vmStateMap, @NonNull IRawInstructionsFile instructionsFile, @NonNull ISourcefileLineMap sourcefileLineMap, @NonNull InstructionCounterFunctions functionsFile, @NonNull TIntObjectMap<String> callPathNames, @NonNull File reportDirectory, int sourceId, @NonNull InstructionCounterSourceMetadata metadata, boolean isSamplesCounter) throws IOException, InterruptedException {
        this.model = model;
        this.metadata = metadata;
        @NonNull @NonNull List events = InstructionCounterConstants.enumerateEvents((File)reportDirectory, (int)sourceId);
        @NonNull InstructionCounterEvent.IEventCounterFactory @NonNull [] eventFactories = new InstructionCounterEvent.IEventCounterFactory[events.size()];
        this.numDataPointsByEvent = new int[events.size()];
        int i = 0;
        while (i < events.size()) {
            // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull InstructionCounterConstants.MetadataPathAndId event = (InstructionCounterConstants.MetadataPathAndId)events.get(i);
            eventFactories[i] = InstructionCounterEvent.createFactory((InstructionCounterMetadataXml)event.metadata, event.id, event.path, isSamplesCounter);
            this.numDataPointsByEvent[i] = eventFactories[i].getNumberOfDataPoints();
            ++i;
        }
        File fileMapperCacheDir = new File(new File(reportDirectory, "cache"), "ic");
        // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull InstructionsAndSourcefileLineCounterViews.DefaultValueMapper.IFileStreamFactory fileMapper = (n2, e, d) -> {
            File file2 = new File(fileMapperCacheDir, String.format("%s-%d-%d-%d.bin", n2, sourceId, e, d));
            if (!fileMapperCacheDir.mkdirs() && !fileMapperCacheDir.isDirectory()) {
                throw new FileNotFoundException(fileMapperCacheDir.getAbsolutePath());
            }
            FileChannel result = FileChannel.open(file2.toPath(), StandardOpenOption.CREATE, StandardOpenOption.DELETE_ON_CLOSE, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.SPARSE);
            if (!result.isOpen()) {
                throw new FileNotFoundException(file2.getAbsolutePath());
            }
            return result;
        };
        this.profileCallPathsFile = new InstructionCounterCallPaths();
        this.instructionAndSourceLineCounterViews = new InstructionsAndSourcefileLineCounterViews(instructionsFile, sourcefileLineMap, this.numDataPointsByEvent, (InstructionsAndSourcefileLineCounterViews.IValueMapper)new InstructionsAndSourcefileLineCounterViews.DefaultValueMapper(false, fileMapper));
        this.callPathAndFunctionCounterViews = (ICallPathAndFunctionCounterViews)this.profileCallPathsFile.load((ICallPathsReader)new CallPathsReader(tracker, reportDirectory, sourceId, CallPath.FACTORY, vmStateMap, callPathNames, ids -> new CallPathAndFunctionCounterViews(ids, (IInstructionCounterFunctions)functionsFile, this.numDataPointsByEvent)));
        this.counters = new ArrayList<InstructionCounterEvent>();
        InstructionCounterEvent samplesCounter = null;
        InstructionCounterEvent.IEventCounterFactory[] iEventCounterFactoryArray = eventFactories;
        int n = eventFactories.length;
        int n3 = 0;
        while (n3 < n) {
            InstructionCounterEvent.IEventCounterFactory eventFactory = iEventCounterFactoryArray[n3];
            @NonNull InstructionCounterEvent counter = eventFactory.createInstructionCounter(IInstructionCounterDataFileLoader.DEFAULT, this, tracker, (IInstructionsAndSourcefileLineCounterViews)this.instructionAndSourceLineCounterViews, (IInstructionCounterCallPaths)this.profileCallPathsFile, this.callPathAndFunctionCounterViews);
            this.counters.add(counter);
            if (counter.isSamplesCounter()) {
                assert (samplesCounter == null);
                samplesCounter = counter;
            }
            ++n3;
        }
        this.samplesCounter = samplesCounter;
        this.largestFunctionCallChainCount = this.callPathAndFunctionCounterViews.calculateLargestFunctionCallChainCount();
        this.counters.sort((a, b) -> {
            int result;
            InstructionCounterEvent instructionCounterEvent;
            InstructionCounterEvent instructionCounterEvent2 = a;
            if (instructionCounterEvent2 instanceof IncidentInstructionCounterEvent) {
                void thatB;
                void thatA;
                IncidentInstructionCounterEvent incidentInstructionCounterEvent = (IncidentInstructionCounterEvent)instructionCounterEvent2;
                IncidentInstructionCounterEvent cfr_ignored_0 = (IncidentInstructionCounterEvent)instructionCounterEvent2;
                boolean aNamedSamples = thatA.getTitle().contentEquals(BacktraceSource.EVENT_METADATA.getTitle());
                InstructionCounterEvent instructionCounterEvent3 = b;
                if (!(instructionCounterEvent3 instanceof IncidentInstructionCounterEvent)) return -1;
                IncidentInstructionCounterEvent incidentInstructionCounterEvent2 = (IncidentInstructionCounterEvent)instructionCounterEvent3;
                IncidentInstructionCounterEvent cfr_ignored_1 = (IncidentInstructionCounterEvent)instructionCounterEvent3;
                boolean bNamedSamples = thatB.getTitle().contentEquals(BacktraceSource.EVENT_METADATA.getTitle());
                if (aNamedSamples != bNamedSamples) {
                    if (!aNamedSamples) return 1;
                    return -1;
                }
            } else {
                InstructionCounterEvent instructionCounterEvent4 = b;
                if (instructionCounterEvent4 instanceof IncidentInstructionCounterEvent) {
                    void thatB;
                    IncidentInstructionCounterEvent aNamedSamples = (IncidentInstructionCounterEvent)instructionCounterEvent4;
                    IncidentInstructionCounterEvent cfr_ignored_2 = (IncidentInstructionCounterEvent)instructionCounterEvent4;
                    boolean bNamedSamples = thatB.getTitle().contentEquals(BacktraceSource.EVENT_METADATA.getTitle());
                    if (bNamedSamples) {
                        return 1;
                    }
                }
            }
            if ((instructionCounterEvent = a) instanceof MetricInstructionCounterEvent) {
                void metricB;
                void metricA;
                MetricInstructionCounterEvent bNamedSamples = (MetricInstructionCounterEvent)instructionCounterEvent;
                MetricInstructionCounterEvent cfr_ignored_3 = (MetricInstructionCounterEvent)instructionCounterEvent;
                InstructionCounterEvent instructionCounterEvent5 = b;
                if (!(instructionCounterEvent5 instanceof MetricInstructionCounterEvent)) return 1;
                MetricInstructionCounterEvent metricInstructionCounterEvent = (MetricInstructionCounterEvent)instructionCounterEvent5;
                MetricInstructionCounterEvent cfr_ignored_4 = (MetricInstructionCounterEvent)instructionCounterEvent5;
                int res = Integer.compare(metricA.getMetric().priority.order, metricB.getMetric().priority.order);
                if (res != 0) {
                    return res;
                }
            } else if (b instanceof MetricInstructionCounterEvent) {
                return -1;
            }
            if ((result = a.getTitle().compareTo(b.getTitle())) == 0) return Integer.compare(a.eventId, b.eventId);
            return result;
        });
    }

    public @NonNull String calculateCallPathTabSelectionText(@NonNull Stream<@NonNull ICallPath> selectionStream) {
        @Nullable InstructionCounterEvent samplesCounter = this.samplesCounter;
        if (samplesCounter == null) {
            return CallPathMessages.NA;
        }
        long total = this.getTotalFunctionSamples();
        long samples = selectionStream.map(ICallPath::getCounters).mapToLong(cs -> cs.getSelfCounterValue(instructionCounterEvent.eventId, 0)).sum();
        return MessageFormat.format(CallPathMessages.SAMPLES_FORMAT, NumberUtils.format((long)samples), NumberUtils.formatPercentage((double)(total > 0L ? (double)samples * 100.0 / (double)total : 0.0), (boolean)false));
    }

    public @NonNull String calculateCodeTabSelectionText(@NonNull Stream<@NonNull IInstructionCounterSourcefileView> selectionStream) {
        @Nullable InstructionCounterEvent samplesCounter = this.samplesCounter;
        if (samplesCounter == null) {
            return CodeMessages.NA;
        }
        long total = this.getTotalFunctionSamples();
        long samples = selectionStream.map(IInstructionCounterSourcefileView::getCounters).mapToLong(cs -> cs.getCounterValue(instructionCounterEvent.eventId, 0)).sum();
        if (samples == 0L) {
            return CodeMessages.NA;
        }
        return MessageFormat.format(CodeMessages.SAMPLES_FORMAT, NumberUtils.format((long)samples), NumberUtils.formatPercentage((double)((double)(100L * samples) / (double)total), (boolean)false));
    }

    public @NonNull String calculateFunctionTabSelectionText(@NonNull Stream<@NonNull IInstructionCounterFunctionView> selectionStream) {
        @Nullable InstructionCounterEvent samplesCounter = this.samplesCounter;
        if (samplesCounter == null) {
            return FunctionMessages.NA;
        }
        long total = this.getTotalFunctionSamples();
        long samples = selectionStream.map(IInstructionCounterFunctionView::getCounterSet).mapToLong(cs -> cs.getSelfCounterValue(instructionCounterEvent.eventId, 0)).sum();
        return MessageFormat.format(FunctionMessages.FORMAT, NumberUtils.format((long)samples), NumberUtils.formatPercentage((double)(total > 0L ? (double)samples * 100.0 / (double)total : 0.0), (boolean)false));
    }

    @Override
    public void close() throws IOException {
        this.instructionAndSourceLineCounterViews.close();
    }

    public @NonNull Callable<@NonNull List<@NonNull SamplesData>> createRecomputeCSMSamplesData(long fromUs, long toUs) {
        @Nullable InstructionCounterEvent samplesCounter = this.samplesCounter;
        return () -> {
            if (samplesCounter != null) {
                return samplesCounter.recomputeCSMSamplesData(fromUs, toUs);
            }
            assert (false);
            return Collections.emptyList();
        };
    }

    public @NonNull Callable<Void> createRecomputeSelectedCounterRange(long fromUs, long toUs) {
        return () -> {
            for (InstructionCounterEvent counter : this.counters) {
                counter.recomputeSelectedCounterRange(fromUs, toUs);
            }
            return null;
        };
    }

    public @NonNull IInstructionCounterCallPaths getCallPaths() {
        return this.profileCallPathsFile;
    }

    public @NonNull IInstructionCounterFunctionViews getFunctionViews() {
        return this.callPathAndFunctionCounterViews;
    }

    public @NonNull Collection<@NonNull IInstructionCounter> getInstructionCounters() {
        return Collections.unmodifiableCollection(this.counters.stream().map(InstructionCounterEvent::getInstructionCounters).flatMap(Collection::stream).collect(Collectors.toList()));
    }

    public @NonNull IInstructionCounterInstructionViews getInstructionViews() {
        return this.instructionAndSourceLineCounterViews;
    }

    public @NonNull String getLargestCallPathName() {
        return this.profileCallPathsFile.getLargestCallPathName();
    }

    public int getLargestFunctionCallPathCount() {
        return this.largestFunctionCallChainCount;
    }

    public double getMaxStack() {
        return this.profileCallPathsFile.getMaxStack();
    }

    public @NonNull InstructionCounterSourceMetadata getMetadata() {
        return this.metadata;
    }

    public @NonNull IInstructionCounterModel getModel() {
        return this.model;
    }

    public @NonNull String getName() {
        return this.metadata.title;
    }

    public @NonNull IInstructionCounterSourcefileViews getSourcefileViews() {
        return this.instructionAndSourceLineCounterViews;
    }

    public long getTotalFunctionSamples() {
        @Nullable InstructionCounterEvent samplesCounter = this.samplesCounter;
        if (samplesCounter != null) {
            return this.callPathAndFunctionCounterViews.getTotal(samplesCounter.eventId, 0);
        }
        return 0L;
    }

    public @NonNull Collection<? extends @NonNull ICallPathFunction> summarizeCallPath(@NonNull ICallPath rootCallPath) {
        @NonNull HashMap<@NonNull IFunction, @NonNull CallPathFunction> result = new HashMap<IFunction, CallPathFunction>();
        long @NonNull [] maximumSelfValues = new long[this.numDataPointsByEvent.length];
        this.summarizeCallPath(maximumSelfValues, rootCallPath, rootCallPath, result);
        return result.values();
    }

    private @NonNull CallPathFunction createCallPathFunction(@NonNull ICallPath callPath, @NonNull IFunction function, long @NonNull [] maximumSelfValues) {
        return new CallPathFunction(callPath, function, this.numDataPointsByEvent, maximumSelfValues);
    }

    private void summarizeCallPath(long @NonNull [] maximumSelfValues, @NonNull ICallPath rootCallPath, @NonNull ICallPath callPath, @NonNull Map<@NonNull IFunction, @NonNull CallPathFunction> map) {
        IFunction function;
        @Nullable IInstructionCounterFunctionView functionView = callPath.getFunction();
        IFunction iFunction = function = functionView != null ? functionView.getFunction() : null;
        if (function != null) {
            CallPathFunction cpf = map.get(function);
            if (cpf == null) {
                cpf = this.createCallPathFunction(rootCallPath, function, maximumSelfValues);
                map.put(function, cpf);
            }
            cpf.addTimeFrom(callPath);
        }
        for (ICallPath child : callPath.getChildren()) {
            this.summarizeCallPath(maximumSelfValues, rootCallPath, child, map);
        }
    }
}

