/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.icounters;

import com.arm.streamline.common.utility.io.IProgressTracker;
import com.arm.streamline.model.icounters.HistogramInstructionCounterEvent;
import com.arm.streamline.model.icounters.IInstructionCounterDataFileLoader;
import com.arm.streamline.model.icounters.IncidentInstructionCounterEvent;
import com.arm.streamline.model.icounters.MetricInstructionCounterEvent;
import com.arm.streamline.model.icounters.RatioInstructionCounterEvent;
import com.arm.streamline.report.model.SamplesData;
import com.arm.streamline.report.model.icounters.IInstructionCounter;
import com.arm.streamline.report.model.icounters.IInstructionCounterCallPaths;
import com.arm.streamline.report.model.icounters.IInstructionCounterSource;
import com.arm.streamline.report.model.icounters.callpathsandfunctions.CallPathAndFunctionIncidentCounterAccumulator;
import com.arm.streamline.report.model.icounters.callpathsandfunctions.ICallPathAndFunctionCounterViews;
import com.arm.streamline.report.model.icounters.impl.RecomputeRangeProperties;
import com.arm.streamline.report.model.icounters.instructionandsource.IInstructionsAndSourcefileLineCounterViews;
import com.arm.streamline.report.shared.icounter.InstructionCounterMetadataXml;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class InstructionCounterEvent {
    protected final int eventId;
    protected final @NonNull IInstructionCounterSource instructionCounterSource;
    protected final @NonNull RecomputeRangeProperties recomputeRangeProperties;

    public static @NonNull IEventCounterFactory createFactory(@NonNull InstructionCounterMetadataXml metadata, final int eventId, final @NonNull File eventPath, final boolean isSamplesCounter) throws IOException {
        return (IEventCounterFactory)metadata.accept((InstructionCounterMetadataXml.IInstructionCounterMetadataXmlVisitor)new InstructionCounterMetadataXml.IInstructionCounterMetadataXmlVisitor<Object, IEventCounterFactory, IOException>(){

            public @NonNull IEventCounterFactory visit(final // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull InstructionCounterMetadataXml.CounterInstructionCounterMetadata value, Object data) throws IOException {
                int @NonNull [] availableDataPoints = InstructionCounterEvent.enumerateDataPoints(eventPath);
                final int @NonNull [] dataPoints = HistogramInstructionCounterEvent.postProcessAvailableDataPoints(value.getMode(), availableDataPoints);
                return new IEventCounterFactory(){

                    @Override
                    public @NonNull InstructionCounterEvent createInstructionCounter(@NonNull IInstructionCounterDataFileLoader dataFileLoader, @NonNull IInstructionCounterSource instructionCounterSource, @NonNull IProgressTracker tracker, @NonNull IInstructionsAndSourcefileLineCounterViews instructionAndSourceLineCounterViews, @NonNull IInstructionCounterCallPaths profileCallPathsFile, @NonNull ICallPathAndFunctionCounterViews callPathAndFunctionCounterViews) throws IOException, InterruptedException {
                        return new HistogramInstructionCounterEvent(dataFileLoader, instructionCounterSource, tracker, instructionAndSourceLineCounterViews, profileCallPathsFile, callPathAndFunctionCounterViews, eventPath, eventId, value, dataPoints);
                    }

                    @Override
                    public int getNumberOfDataPoints() {
                        return dataPoints.length;
                    }
                };
            }

            public @NonNull IEventCounterFactory visit(final // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull InstructionCounterMetadataXml.RatioInstructionCounterMetadata value, Object data) throws IOException {
                if (value.getDataPoints().size() != 1) {
                    return new IEventCounterFactory(){

                        @Override
                        public @NonNull InstructionCounterEvent createInstructionCounter(@NonNull IInstructionCounterDataFileLoader dataFileLoader, @NonNull IInstructionCounterSource instructionCounterSource, @NonNull IProgressTracker tracker, @NonNull IInstructionsAndSourcefileLineCounterViews instructionAndSourceLineCounterViews, @NonNull IInstructionCounterCallPaths profileCallPathsFile, @NonNull ICallPathAndFunctionCounterViews callPathAndFunctionCounterViews) throws IOException, InterruptedException {
                            return new RatioInstructionCounterEvent(dataFileLoader, instructionCounterSource, tracker, instructionAndSourceLineCounterViews, profileCallPathsFile, callPathAndFunctionCounterViews, eventPath, eventId, value);
                        }

                        @Override
                        public int getNumberOfDataPoints() {
                            return value.getDataPoints().size();
                        }
                    };
                }
                return new IEventCounterFactory(){

                    @Override
                    public @NonNull InstructionCounterEvent createInstructionCounter(@NonNull IInstructionCounterDataFileLoader dataFileLoader, @NonNull IInstructionCounterSource instructionCounterSource, @NonNull IProgressTracker tracker, @NonNull IInstructionsAndSourcefileLineCounterViews instructionAndSourceLineCounterViews, @NonNull IInstructionCounterCallPaths profileCallPathsFile, @NonNull ICallPathAndFunctionCounterViews callPathAndFunctionCounterViews) throws IOException, InterruptedException {
                        return new IncidentInstructionCounterEvent(dataFileLoader, instructionCounterSource, tracker, instructionAndSourceLineCounterViews, profileCallPathsFile, callPathAndFunctionCounterViews, eventPath, eventId, value, isSamplesCounter);
                    }

                    @Override
                    public int getNumberOfDataPoints() {
                        return 1;
                    }
                };
            }

            public @NonNull IEventCounterFactory visit(final // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull InstructionCounterMetadataXml.MetricInstructionCounterMetadata value, Object data) throws IOException {
                final int @NonNull [] availableDataPoints = InstructionCounterEvent.enumerateDataPoints(eventPath);
                return new IEventCounterFactory(){

                    @Override
                    public @NonNull InstructionCounterEvent createInstructionCounter(@NonNull IInstructionCounterDataFileLoader dataFileLoader, @NonNull IInstructionCounterSource instructionCounterSource, @NonNull IProgressTracker tracker, @NonNull IInstructionsAndSourcefileLineCounterViews instructionAndSourceLineCounterViews, @NonNull IInstructionCounterCallPaths profileCallPathsFile, @NonNull ICallPathAndFunctionCounterViews callPathAndFunctionCounterViews) throws IOException, InterruptedException {
                        return new MetricInstructionCounterEvent(dataFileLoader, instructionCounterSource, tracker, instructionAndSourceLineCounterViews, profileCallPathsFile, callPathAndFunctionCounterViews, eventPath, eventId, value, availableDataPoints);
                    }

                    @Override
                    public int getNumberOfDataPoints() {
                        return availableDataPoints.length;
                    }
                };
            }
        }, null);
    }

    protected static int @NonNull [] enumerateDataPoints(@NonNull File counterDir) throws FileNotFoundException {
        @NonNull File @Nullable [] children = counterDir.listFiles(child -> child.isDirectory() && child.getName().matches("^\\d+$"));
        if (children == null) {
            throw new FileNotFoundException(counterDir.getAbsolutePath());
        }
        int @NonNull [] availableDataPointIds = new int[children.length];
        if (availableDataPointIds.length == 0) {
            return availableDataPointIds;
        }
        int i = 0;
        while (i < children.length) {
            availableDataPointIds[i] = Integer.parseInt(children[i].getName());
            ++i;
        }
        Arrays.sort(availableDataPointIds);
        return availableDataPointIds;
    }

    protected static void loadInitialValues(@NonNull IInstructionCounterDataFileLoader dataFileLoader, @NonNull IProgressTracker tracker, @NonNull File dataPointDir, int eventId, int dataPointIndex, @NonNull ICallPathAndFunctionCounterViews callPathAndFunctionCounterViews, @NonNull IInstructionsAndSourcefileLineCounterViews instructionAndSourceLineCounterViews) throws IOException, InterruptedException {
        Throwable throwable = null;
        Object var8_9 = null;
        try (CallPathAndFunctionIncidentCounterAccumulator accumulator = callPathAndFunctionCounterViews.createAccumulator(eventId, dataPointIndex);){
            dataFileLoader.loadCallPathCounts(tracker, dataPointDir, (arg_0, arg_1) -> ((CallPathAndFunctionIncidentCounterAccumulator)accumulator).addSelection(arg_0, arg_1));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        dataFileLoader.load(tracker, dataPointDir, eventId, dataPointIndex, instructionAndSourceLineCounterViews);
    }

    protected InstructionCounterEvent(@NonNull IInstructionCounterSource instructionCounterSource, int eventId, @NonNull IInstructionsAndSourcefileLineCounterViews instructionAndSourceLineCounterViews, @NonNull IInstructionCounterCallPaths profileCallPathsFile, @NonNull ICallPathAndFunctionCounterViews callPathAndFunctionCounterViews) throws IOException {
        this.instructionCounterSource = instructionCounterSource;
        this.eventId = eventId;
        this.recomputeRangeProperties = new RecomputeRangeProperties(profileCallPathsFile, callPathAndFunctionCounterViews, instructionAndSourceLineCounterViews);
    }

    public abstract @NonNull List<@NonNull IInstructionCounter> getInstructionCounters();

    public abstract @NonNull String getTitle();

    public abstract boolean isSamplesCounter();

    public abstract @NonNull List<@NonNull SamplesData> recomputeCSMSamplesData(long var1, long var3) throws Exception;

    public abstract void recomputeSelectedCounterRange(long var1, long var3) throws Exception;

    public static interface IEventCounterFactory {
        public @NonNull InstructionCounterEvent createInstructionCounter(@NonNull IInstructionCounterDataFileLoader var1, @NonNull IInstructionCounterSource var2, @NonNull IProgressTracker var3, @NonNull IInstructionsAndSourcefileLineCounterViews var4, @NonNull IInstructionCounterCallPaths var5, @NonNull ICallPathAndFunctionCounterViews var6) throws IOException, InterruptedException;

        public int getNumberOfDataPoints();
    }
}

