/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.icounters;

import com.arm.streamline.common.model.icounters.IRatioInstructionCounterDataPoint;
import com.arm.streamline.common.utility.io.IProgressTracker;
import com.arm.streamline.model.icounters.IInstructionCounterDataFileLoader;
import com.arm.streamline.model.icounters.InstructionCounter;
import com.arm.streamline.model.icounters.InstructionCounterEvent;
import com.arm.streamline.model.icounters.incident.IIncidentColumnProvider;
import com.arm.streamline.model.icounters.incident.IncidentCallPathFunctionInstructionCounterColumns;
import com.arm.streamline.model.icounters.incident.IncidentCallpathInstructionCounterColumns;
import com.arm.streamline.model.icounters.incident.IncidentCodeInstructionCounterColumns;
import com.arm.streamline.model.icounters.incident.IncidentFunctionInstructionCounterColumns;
import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.ICallPathFunction;
import com.arm.streamline.report.model.SamplesData;
import com.arm.streamline.report.model.icounters.IInstructionCounter;
import com.arm.streamline.report.model.icounters.IInstructionCounterCallPaths;
import com.arm.streamline.report.model.icounters.IInstructionCounterColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctionView;
import com.arm.streamline.report.model.icounters.IInstructionCounterSource;
import com.arm.streamline.report.model.icounters.InstructionCounterConstants;
import com.arm.streamline.report.model.icounters.callpathsandfunctions.ICallPathAndFunctionCounterViews;
import com.arm.streamline.report.model.icounters.impl.RecomputeCSMSamples;
import com.arm.streamline.report.model.icounters.impl.RecomputeRange;
import com.arm.streamline.report.model.icounters.instructionandsource.IInstructionsAndSourcefileLineCounterViews;
import com.arm.streamline.report.model.icounters.io.IIncidentCounterDataSource;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public final class IncidentInstructionCounterEvent
extends InstructionCounterEvent
implements IIncidentColumnProvider {
    protected static final int DATA_POINT_INDEX = 0;
    private final @NonNull List<@NonNull IInstructionCounter> counters;
    private final int dataPointId;
    private final @NonNull IIncidentCounterDataSource dataSource;
    private final boolean samplesCounter;
    private final @NonNull String title;

    public IncidentInstructionCounterEvent(@NonNull IInstructionCounterDataFileLoader dataFileLoader, @NonNull IInstructionCounterSource instructionCounterSource, @NonNull IProgressTracker tracker, @NonNull IInstructionsAndSourcefileLineCounterViews instructionAndSourceLineCounterViews, @NonNull IInstructionCounterCallPaths profileCallPathsFile, @NonNull ICallPathAndFunctionCounterViews callPathAndFunctionCounterViews, @NonNull File eventDir, int eventId, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull InstructionCounterMetadataXml.RatioInstructionCounterMetadata metadata, boolean isSamplesCounter) throws IOException, InterruptedException {
        super(instructionCounterSource, eventId, instructionAndSourceLineCounterViews, profileCallPathsFile, callPathAndFunctionCounterViews);
        this.title = metadata.getTitle();
        @NonNull IRatioInstructionCounterDataPoint dp = (IRatioInstructionCounterDataPoint)metadata.getDataPoints().get(0);
        this.dataPointId = dp.getID();
        this.samplesCounter = isSamplesCounter;
        @NonNull File dataPointDir = InstructionCounterConstants.getDataPointPath((File)eventDir, (int)this.dataPointId);
        IncidentInstructionCounterEvent.loadInitialValues(dataFileLoader, tracker, dataPointDir, eventId, 0, callPathAndFunctionCounterViews, instructionAndSourceLineCounterViews);
        this.dataSource = dataFileLoader.createIncidentCounterDataSource(dataPointDir);
        IncidentFunctionInstructionCounterColumns functionCounterColumns = new IncidentFunctionInstructionCounterColumns(this, eventId, 0, metadata.getTitle(), metadata.getDescription(), metadata.getUnit(), dp.getName(), dp.getColourRGB());
        IncidentCallpathInstructionCounterColumns callPathCounterColumns = new IncidentCallpathInstructionCounterColumns(this, eventId, 0, metadata.getTitle(), metadata.getDescription(), metadata.getUnit(), dp.getName(), dp.getColourRGB());
        IncidentCallPathFunctionInstructionCounterColumns callPathFunctionCounterColumns = new IncidentCallPathFunctionInstructionCounterColumns(this, eventId, 0, metadata.getTitle(), metadata.getDescription(), metadata.getUnit(), dp.getName(), dp.getColourRGB());
        IncidentCodeInstructionCounterColumns codeCounterColumns = new IncidentCodeInstructionCounterColumns(this, eventId, 0, metadata.getTitle(), metadata.getDescription(), metadata.getUnit(), dp.getName(), dp.getColourRGB());
        this.counters = Arrays.asList(new InstructionCounter((IInstructionCounterColumn<ICallPath>)callPathCounterColumns.TOTAL_VALUE_PERCENT, null, null, null), new InstructionCounter((IInstructionCounterColumn<ICallPath>)callPathCounterColumns.SELF_VALUE_PERCENT, (IInstructionCounterColumn<IInstructionCounterFunctionView>)functionCounterColumns.SELF_VALUE_PERCENT, (IInstructionCounterColumn<ICallPathFunction>)callPathFunctionCounterColumns.SELF_VALUE_PERCENT, codeCounterColumns.SELF_VALUE_PERCENT), new InstructionCounter((IInstructionCounterColumn<ICallPath>)callPathCounterColumns.PROCESS_PERCENT, (IInstructionCounterColumn<IInstructionCounterFunctionView>)functionCounterColumns.TOTAL_VALUE_PERCENT, null, null));
    }

    @Override
    public @NonNull List<@NonNull IInstructionCounter> getInstructionCounters() {
        return this.counters;
    }

    @Override
    public @NonNull IInstructionCounterSource getInstructionCounterSource() {
        return this.instructionCounterSource;
    }

    @Override
    public @NonNull String getTitle() {
        return this.title;
    }

    @Override
    public long getTotal(int eventId, int dataPointIndex) {
        assert (eventId == this.eventId);
        assert (dataPointIndex == 0);
        return this.recomputeRangeProperties.getCallPathsAndFunctions().getTotal(eventId, dataPointIndex);
    }

    @Override
    public boolean isSamplesCounter() {
        return this.samplesCounter;
    }

    @Override
    public @NonNull List<@NonNull SamplesData> recomputeCSMSamplesData(long fromUs, long toUs) throws Exception {
        assert (this.isSamplesCounter());
        return new RecomputeCSMSamples(this.recomputeRangeProperties, this.dataSource, fromUs, toUs).call();
    }

    @Override
    public void recomputeSelectedCounterRange(long fromUs, long toUs) throws Exception {
        new RecomputeRange(this.recomputeRangeProperties, this.dataSource, this.eventId, 0, fromUs, toUs).call();
    }
}

