/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.chart;

import com.arm.streamline.common.model.counters.GraphRenderingType;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.annotation.VisualAnnotation;
import com.arm.streamline.model.annotation.VisualAnnotationData;
import com.arm.streamline.model.capture.ChartConfig;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.model.capture.IWildcardSeriesDataProvider;
import com.arm.streamline.model.capture.SeriesConfig;
import com.arm.streamline.model.capture.WildcardSeriesConfig;
import com.arm.streamline.report.model.pe.ProcessingElementTopology;
import com.arm.streamline.report.model.uids.AbstractPerVmId;
import com.arm.utils.NullChecking;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class VisualChartDataProvider
implements IChartDataProvider {
    private static final @NonNull IChartDataProvider.IChartCoreInformationProvider CORE_INFORMATION_PROVIDER = new IChartDataProvider.IChartCoreInformationProvider(){
        private final @NonNull ProcessingElementReference @NonNull [] CORES = new ProcessingElementReference[0];

        @Override
        public @NonNull ProcessingElementReference @NonNull [] getChannelDescriptors() {
            return this.CORES;
        }

        @Override
        public @Nullable String getChannelName(@NonNull ProcessingElementReference peReference) {
            return VisualChartDataProvider.EMPTY;
        }

        @Override
        public int getCoreColourIndex(@NonNull ProcessingElementReference processingElementReference) {
            return -1;
        }

        @Override
        public DeviceType getDeviceType() {
            return DeviceType.CPU;
        }

        @Override
        public @Nullable ProcessingElementTopology getTopology(@NonNull ProcessingElementReference peReference) {
            return null;
        }

        @Override
        public @Nullable String getVmName(@Nullable ProcessingElementReference peReference) {
            return null;
        }

        @Override
        public boolean hasMultipleVms() {
            return false;
        }
    };
    private static final String EMPTY = "";
    private final @NonNull ICaptureDataProvider mCaptureDataProvider;
    private final @NonNull ChartConfig mChartConfig;
    private VisualAnnotationData mEmptyData;

    public VisualChartDataProvider(@NonNull ICaptureDataProvider captureDataProvider, @NonNull ChartConfig config) {
        this.mCaptureDataProvider = captureDataProvider;
        this.mChartConfig = config;
        config.setSeriesComposition(SeriesComposition.VISUAL_ANNOTATION);
        this.mEmptyData = new VisualAnnotationData(null, config.getTitle(), new ArrayList<VisualAnnotation>(), (AbstractPerVmId.PerVmNonUniquePid)NullChecking.neverNull((Object)config.getID()));
    }

    @Override
    public boolean canCoresBeAveraged() {
        return false;
    }

    @Override
    public ISeriesDataProvider createSeries(@NonNull SeriesConfig config) {
        throw new AssertionError((Object)"Tried to create series for visual chart");
    }

    @Override
    public ISeriesDataProvider createSeries(int index, @NonNull SeriesConfig config) {
        throw new AssertionError((Object)"Tried to create series for visual chart");
    }

    @Override
    public double getAggregateLimit() {
        return 0.0;
    }

    @Override
    public long getAlignment() {
        return 0L;
    }

    @Override
    public ICaptureDataProvider getCaptureDataProvider() {
        return this.mCaptureDataProvider;
    }

    @Override
    public @NonNull IChartDataProvider.IChartCoreInformationProvider getCoreInformationProvider() {
        return CORE_INFORMATION_PROVIDER;
    }

    @Override
    public double getCoreLimit() {
        return 0.0;
    }

    @Override
    public int getHeight() {
        return 0;
    }

    @Override
    public GraphRenderingType getRenderingType() {
        return GraphRenderingType.DEFAULT;
    }

    @Override
    public List<ISeriesDataProvider> getSeries() {
        return new ArrayList<ISeriesDataProvider>();
    }

    @Override
    public SeriesComposition getSeriesComposition() {
        return SeriesComposition.VISUAL_ANNOTATION;
    }

    @Override
    public String getTitle() {
        return this.getCaptureDataProvider().getVariableReplacer().replace(this.getTitleFormat());
    }

    @Override
    public @NonNull String getTitleFormat() {
        return this.mChartConfig.getTitle();
    }

    @Override
    public String getUnits() {
        return EMPTY;
    }

    @Override
    public VisualAnnotationData getVisualAnnotationData() {
        ICaptureDataProvider provider = this.getCaptureDataProvider();
        if (provider.isLive()) {
            return this.mEmptyData;
        }
        return ((Analysis)provider).getVisualAnnotations().getVisualAnnotationData((AbstractPerVmId.PerVmNonUniquePid)NullChecking.neverNull((Object)this.mChartConfig.getID()));
    }

    @Override
    public boolean isAlignmentLinked() {
        return false;
    }

    @Override
    public boolean isAlignmentSupported() {
        return false;
    }

    @Override
    public boolean isAverageCores() {
        return false;
    }

    @Override
    public boolean isAverageSelection() {
        return false;
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    @Override
    public boolean isHeatMapLineEnabled() {
        return false;
    }

    @Override
    public boolean isPercentage() {
        return false;
    }

    @Override
    public void setAlignment(long alignment) {
    }

    @Override
    public void setAlignmentLinked(boolean linked) {
    }

    @Override
    public void setAverageCores(boolean average) {
    }

    @Override
    public void setAverageSelection(boolean average) {
    }

    @Override
    public void setHeight(int height) {
    }

    @Override
    public void setOpen(boolean open) {
    }

    @Override
    public void setPercentage(boolean percentage) {
    }

    @Override
    public void setRenderingType(GraphRenderingType type) {
    }

    @Override
    public void setSeriesComposition(SeriesComposition composition) {
    }

    @Override
    public void setTitleFormat(String title) {
        this.mChartConfig.setTitle(title);
    }

    public String toString() {
        return "Visual Annotation Chart: " + String.valueOf(this.mChartConfig.getID());
    }

    @Override
    public void remove(ISeriesDataProvider series) {
    }

    @Override
    public @NonNull ChartConfig getChartConfig() {
        return this.mChartConfig;
    }

    @Override
    public void setHeatMapLineEnabled(boolean heatMapEnabled) {
    }

    @Override
    public @NonNull IWildcardSeriesDataProvider createWildcardSeries(@NonNull WildcardSeriesConfig config) {
        throw new AssertionError((Object)"Not supported, Tried to create wildcard series for visual chart");
    }

    @Override
    public @NonNull List<@NonNull IWildcardSeriesDataProvider> getWildcardSeries() {
        return Collections.emptyList();
    }

    @Override
    public void remove(@NonNull IWildcardSeriesDataProvider wildcardSeriesDataProvider) {
    }
}

