/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.chart;

import com.arm.streamline.common.model.ZoomLevel;
import org.eclipse.jdt.annotation.NonNull;

@FunctionalInterface
public interface ITimelineLadderWalker {
    public static void walkLadder(@NonNull ZoomLevel @NonNull [] allZoomLevels, @NonNull ZoomLevel uiZoomLevel, long ladderStartInDensestBps, long numBinsInDensestBps, @NonNull ITimelineLadderWalker callback) {
        int densestBps = allZoomLevels[allZoomLevels.length - 1].getBps();
        int i = -(allZoomLevels.length - 1);
        while (numBinsInDensestBps > 0L && i < allZoomLevels.length) {
            long thisLevelBps = allZoomLevels[Math.abs(i)].getBps();
            long startAtThisBps = ladderStartInDensestBps * thisLevelBps / (long)densestBps;
            long startRoundFromThisToDensestBps = startAtThisBps * (long)densestBps / thisLevelBps;
            long lengthAtThisBps = numBinsInDensestBps * thisLevelBps / (long)densestBps;
            if (startRoundFromThisToDensestBps == ladderStartInDensestBps && lengthAtThisBps > 0L) {
                long lengthToUseInDensestBps;
                long lengthRoundFromThisToDensestBps = lengthAtThisBps * (long)densestBps / thisLevelBps;
                long l = lengthToUseInDensestBps = lengthRoundFromThisToDensestBps <= numBinsInDensestBps ? lengthRoundFromThisToDensestBps : (lengthAtThisBps - 1L) * (long)densestBps / thisLevelBps;
                if (lengthToUseInDensestBps > 0L && lengthToUseInDensestBps <= numBinsInDensestBps) {
                    int bestLevel = i;
                    long bpsToUse = thisLevelBps;
                    long startToUse = startAtThisBps;
                    long lengthToUse = lengthAtThisBps;
                    long densestLengthToUse = lengthToUseInDensestBps;
                    int j = i + 1;
                    while (j <= 0) {
                        long nextLengthToUseInDensestBps;
                        long nextLevelBps = allZoomLevels[-j].getBps();
                        long startAtNextBps = ladderStartInDensestBps * nextLevelBps / (long)densestBps;
                        long startRoundFromNextToDensestBps = startAtNextBps * (long)densestBps / nextLevelBps;
                        long lengthAtNextBps = numBinsInDensestBps * nextLevelBps / (long)densestBps;
                        if (startRoundFromNextToDensestBps != ladderStartInDensestBps || lengthAtNextBps <= 0L) {
                            long subsequentRoundFromNextToDensestBps = (startAtNextBps + 1L) * (long)densestBps / nextLevelBps;
                            long distanceToSubsequentAtDensestBps = subsequentRoundFromNextToDensestBps - ladderStartInDensestBps;
                            long distanceToSubsequentAtBestBps = distanceToSubsequentAtDensestBps * bpsToUse / (long)densestBps;
                            long roundedBestDistanceAtDensestBps = distanceToSubsequentAtBestBps * (long)densestBps / bpsToUse;
                            long remainingAfterAlignmentAtDensestBps = numBinsInDensestBps - roundedBestDistanceAtDensestBps;
                            long remainingAfterAlignmentAtNextBps = remainingAfterAlignmentAtDensestBps * nextLevelBps / (long)densestBps;
                            if (distanceToSubsequentAtDensestBps <= 0L || distanceToSubsequentAtBestBps <= 0L || remainingAfterAlignmentAtNextBps <= 0L || distanceToSubsequentAtDensestBps != roundedBestDistanceAtDensestBps) break;
                            lengthToUse = distanceToSubsequentAtBestBps;
                            densestLengthToUse = roundedBestDistanceAtDensestBps;
                            break;
                        }
                        long lengthRoundFromNextToDensestBps = lengthAtNextBps * (long)densestBps / nextLevelBps;
                        long l2 = nextLengthToUseInDensestBps = lengthRoundFromNextToDensestBps <= numBinsInDensestBps ? lengthRoundFromNextToDensestBps : (lengthAtNextBps - 1L) * (long)densestBps / nextLevelBps;
                        if (nextLengthToUseInDensestBps <= 0L || nextLengthToUseInDensestBps > numBinsInDensestBps) break;
                        bestLevel = j++;
                        bpsToUse = nextLevelBps;
                        startToUse = startAtNextBps;
                        lengthToUse = lengthAtNextBps;
                        densestLengthToUse = nextLengthToUseInDensestBps;
                    }
                    double averageFactor = (double)uiZoomLevel.getBps() / (double)bpsToUse;
                    callback.step(allZoomLevels[Math.abs(bestLevel)], Math.toIntExact(startToUse), Math.toIntExact(lengthToUse), averageFactor);
                    ladderStartInDensestBps += densestLengthToUse;
                    numBinsInDensestBps -= densestLengthToUse;
                    i = bestLevel;
                }
            }
            ++i;
        }
    }

    public void step(@NonNull ZoomLevel var1, int var2, int var3, double var4);
}

